/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.misc.HttpClient;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class RaftProxy {
    public void proxyGet(String server, String api, Map<String, String> params) throws Exception {
        if (!server.contains(":")) {
            server = server + ":" + ApplicationUtils.getPort();
        }
        String url = "http://" + server + ApplicationUtils.getContextPath() + api;
        HttpClient.HttpResult result = HttpClient.httpGet(url, null, params);
        if (result.code != 200) {
            throw new IllegalStateException("leader failed, caused by: " + result.content);
        }
    }

    public void proxy(String server, String api, Map<String, String> params, HttpMethod method) throws Exception {
        HttpClient.HttpResult result;
        if (!server.contains(":")) {
            server = server + ":" + ApplicationUtils.getPort();
        }
        String url = "http://" + server + ApplicationUtils.getContextPath() + api;
        switch (method) {
            case GET: {
                result = HttpClient.httpGet(url, null, params);
                break;
            }
            case POST: {
                result = HttpClient.httpPost(url, null, params);
                break;
            }
            case DELETE: {
                result = HttpClient.httpDelete(url, null, params);
                break;
            }
            default: {
                throw new RuntimeException("unsupported method:" + method);
            }
        }
        if (result.code != 200) {
            throw new IllegalStateException("leader failed, caused by: " + result.content);
        }
    }

    public void proxyPostLarge(String server, String api, String content, Map<String, String> headers) throws Exception {
        if (!server.contains(":")) {
            server = server + ":" + ApplicationUtils.getPort();
        }
        String url = "http://" + server + ApplicationUtils.getContextPath() + api;
        HttpClient.HttpResult result = HttpClient.httpPostLarge(url, headers, content);
        if (result.code != 200) {
            throw new IllegalStateException("leader failed, caused by: " + result.content);
        }
    }
}

