/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.utils.OverrideParameterRequestWrapper;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.controllers.InstanceController;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.push.ClientInfo;
import com.alibaba.nacos.naming.web.CanDistro;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.jackson.util.VersionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Deprecated
@RequestMapping(value={"/v1/ns/api"})
public class ApiController
extends InstanceController {
    @Autowired
    private DistroMapper distroMapper;
    @Autowired
    private ServiceManager serviceManager;

    @RequestMapping(value={"/allDomNames"})
    public ObjectNode allDomNames(HttpServletRequest request) throws Exception {
        boolean responsibleOnly = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"responsibleOnly", (String)"false"));
        Map<String, Set<String>> domMap = this.serviceManager.getAllServiceNames();
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        String dnsfVersion = "1.0.1";
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        ClientInfo clientInfo = new ClientInfo(agent);
        if (clientInfo.type == ClientInfo.ClientType.DNS && clientInfo.version.compareTo(VersionUtil.parseVersion((String)dnsfVersion)) <= 0) {
            ArrayList<String> doms = new ArrayList<String>();
            Set<String> domSet = null;
            if (domMap.containsKey("public")) {
                domSet = domMap.get("public");
            }
            if (CollectionUtils.isEmpty(domSet)) {
                result.put("doms", JacksonUtils.transferToJsonNode(new HashSet()));
                result.put("count", 0);
                return result;
            }
            for (String dom : domSet) {
                if (!this.distroMapper.responsible(dom) && responsibleOnly) continue;
                doms.add(NamingUtils.getServiceName((String)dom));
            }
            result.put("doms", JacksonUtils.transferToJsonNode(doms));
            result.put("count", doms.size());
            return result;
        }
        HashMap doms = new HashMap(16);
        int count = 0;
        for (String namespaceId : domMap.keySet()) {
            doms.put(namespaceId, new HashSet());
            for (String dom : domMap.get(namespaceId)) {
                if (!this.distroMapper.responsible(dom) && responsibleOnly) continue;
                ((Set)doms.get(namespaceId)).add(NamingUtils.getServiceName((String)dom));
            }
            count += ((Set)doms.get(namespaceId)).size();
        }
        result.put("doms", JacksonUtils.transferToJsonNode(doms));
        result.put("count", count);
        return result;
    }

    @RequestMapping(value={"/srvIPXT"})
    @ResponseBody
    public ObjectNode srvIpxt(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String dom = WebUtils.required((HttpServletRequest)request, (String)"dom");
        String agent = WebUtils.getUserAgent((HttpServletRequest)request);
        String clusters = WebUtils.optional((HttpServletRequest)request, (String)"clusters", (String)"");
        String clientIP = WebUtils.optional((HttpServletRequest)request, (String)"clientIP", (String)"");
        Integer udpPort = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)"udpPort", (String)"0"));
        String env = WebUtils.optional((HttpServletRequest)request, (String)"env", (String)"");
        boolean isCheck = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"isCheck", (String)"false"));
        String app = WebUtils.optional((HttpServletRequest)request, (String)"app", (String)"");
        String tenant = WebUtils.optional((HttpServletRequest)request, (String)"tid", (String)"");
        boolean healthyOnly = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"healthyOnly", (String)"false"));
        return this.doSrvIpxt(namespaceId, NamingUtils.getGroupedName((String)dom, (String)"DEFAULT_GROUP"), agent, clusters, clientIP, udpPort, env, isCheck, app, tenant, healthyOnly);
    }

    @CanDistro
    @RequestMapping(value={"/clientBeat"})
    public ObjectNode clientBeat(HttpServletRequest request) throws Exception {
        OverrideParameterRequestWrapper requestWrapper = OverrideParameterRequestWrapper.buildRequest((HttpServletRequest)request);
        requestWrapper.addParameter("serviceName", "DEFAULT_GROUP@@" + WebUtils.required((HttpServletRequest)request, (String)"dom"));
        return this.beat((HttpServletRequest)requestWrapper);
    }
}

