/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.cluster.transport.Serializer;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.DataStore;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.DistroConsistencyServiceImpl;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.Record;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/distro"})
public class DistroController {
    @Autowired
    private Serializer serializer;
    @Autowired
    private DistroConsistencyServiceImpl consistencyService;
    @Autowired
    private DataStore dataStore;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private SwitchDomain switchDomain;

    @PutMapping(value={"/datum"})
    public ResponseEntity onSyncDatum(@RequestBody Map<String, Datum<Instances>> dataMap) throws Exception {
        if (dataMap.isEmpty()) {
            Loggers.DISTRO.error("[onSync] receive empty entity!");
            throw new NacosException(400, "receive empty entity!");
        }
        for (Map.Entry<String, Datum<Instances>> entry : dataMap.entrySet()) {
            String serviceName;
            if (!KeyBuilder.matchEphemeralInstanceListKey(entry.getKey())) continue;
            String namespaceId = KeyBuilder.getNamespace(entry.getKey());
            if (!this.serviceManager.containService(namespaceId, serviceName = KeyBuilder.getServiceName(entry.getKey())) && this.switchDomain.isDefaultInstanceEphemeral()) {
                this.serviceManager.createEmptyService(namespaceId, serviceName, true);
            }
            this.consistencyService.onPut(entry.getKey(), (Record)entry.getValue().value);
        }
        return ResponseEntity.ok((Object)"ok");
    }

    @PutMapping(value={"/checksum"})
    public ResponseEntity syncChecksum(@RequestParam String source, @RequestBody Map<String, String> dataMap) {
        this.consistencyService.onReceiveChecksums(dataMap, source);
        return ResponseEntity.ok((Object)"ok");
    }

    @GetMapping(value={"/datum"})
    public ResponseEntity get(@RequestBody String body) throws Exception {
        JsonNode bodyNode = JacksonUtils.toObj((String)body);
        String keys = bodyNode.get("keys").asText();
        String keySplitter = ",";
        HashMap<String, Datum> datumMap = new HashMap<String, Datum>(64);
        for (String key : keys.split(keySplitter)) {
            Datum datum = this.consistencyService.get(key);
            if (datum == null) continue;
            datumMap.put(key, datum);
        }
        byte[] content = this.serializer.serialize(datumMap);
        return ResponseEntity.ok((Object)content);
    }

    @GetMapping(value={"/datums"})
    public ResponseEntity getAllDatums() {
        byte[] content = this.serializer.serialize(this.dataStore.getDataMap());
        return ResponseEntity.ok((Object)content);
    }
}

