/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.auth.ActionTypes;
import com.alibaba.nacos.core.auth.Secured;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.SubscribeManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.selector.LabelSelector;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.Selector;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/service"})
public class ServiceController {
    @Autowired
    protected ServiceManager serviceManager;
    @Autowired
    private DistroMapper distroMapper;
    @Autowired
    private ServerMemberManager memberManager;
    @Autowired
    private SubscribeManager subscribeManager;

    @PostMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String create(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(required=false) float protectThreshold, @RequestParam(defaultValue="") String metadata, @RequestParam(defaultValue="") String selector) throws Exception {
        if (this.serviceManager.getService(namespaceId, serviceName) != null) {
            throw new IllegalArgumentException("specified service already exists, serviceName : " + serviceName);
        }
        Map<Object, Object> metadataMap = new HashMap(16);
        if (StringUtils.isNotBlank((CharSequence)metadata)) {
            metadataMap = UtilsAndCommons.parseMetadata(metadata);
        }
        Service service = new Service(serviceName);
        service.setProtectThreshold(protectThreshold);
        service.setEnabled(true);
        service.setMetadata(metadataMap);
        service.setSelector(this.parseSelector(selector));
        service.setNamespaceId(namespaceId);
        service.setLastModifiedMillis(System.currentTimeMillis());
        service.recalculateChecksum();
        service.validate();
        this.serviceManager.addOrReplaceService(service);
        return "ok";
    }

    @DeleteMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String remove(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) throws Exception {
        this.serviceManager.easyRemoveService(namespaceId, serviceName);
        return "ok";
    }

    @GetMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode detail(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName) throws NacosException {
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(404, "service " + serviceName + " is not found!");
        }
        ObjectNode res = JacksonUtils.createEmptyJsonNode();
        res.put("name", NamingUtils.getServiceName((String)serviceName));
        res.put("namespaceId", service.getNamespaceId());
        res.put("protectThreshold", service.getProtectThreshold());
        res.replace("metadata", JacksonUtils.transferToJsonNode((Object)service.getMetadata()));
        res.replace("selector", JacksonUtils.transferToJsonNode((Object)service.getSelector()));
        res.put("groupName", NamingUtils.getGroupName((String)serviceName));
        ArrayNode clusters = JacksonUtils.createEmptyArrayNode();
        for (Cluster cluster : service.getClusterMap().values()) {
            ObjectNode clusterJson = JacksonUtils.createEmptyJsonNode();
            clusterJson.put("name", cluster.getName());
            clusterJson.replace("healthChecker", JacksonUtils.transferToJsonNode((Object)cluster.getHealthChecker()));
            clusterJson.replace("metadata", JacksonUtils.transferToJsonNode((Object)cluster.getMetadata()));
            clusters.add((JsonNode)clusterJson);
        }
        res.replace("clusters", (JsonNode)clusters);
        return res;
    }

    @GetMapping(value={"/list"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode list(HttpServletRequest request) throws Exception {
        int end;
        int start;
        int pageNo = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageNo"));
        int pageSize = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageSize"));
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String groupName = WebUtils.optional((HttpServletRequest)request, (String)"groupName", (String)"DEFAULT_GROUP");
        String selectorString = WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"");
        List<String> serviceNameList = this.serviceManager.getAllServiceNameList(namespaceId);
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        if (serviceNameList == null || serviceNameList.isEmpty()) {
            result.replace("doms", JacksonUtils.transferToJsonNode(Collections.emptyList()));
            result.put("count", 0);
            return result;
        }
        serviceNameList.removeIf(serviceName -> !serviceName.startsWith(groupName + "@@"));
        if (StringUtils.isNotBlank((CharSequence)selectorString)) {
            JsonNode selectorJson = JacksonUtils.toObj((String)selectorString);
            SelectorType selectorType = SelectorType.valueOf((String)selectorJson.get("type").asText());
            String expression = selectorJson.get("expression").asText();
            if (SelectorType.label.equals((Object)selectorType) && StringUtils.isNotBlank((CharSequence)expression)) {
                expression = StringUtils.deleteWhitespace((String)expression);
                String[] terms = expression.split("=");
                String[] factors = terms[0].split("\\.");
                switch (factors[0]) {
                    case "INSTANCE": {
                        serviceNameList = this.filterInstanceMetadata(namespaceId, serviceNameList, factors[factors.length - 1], terms[1].replace("'", ""));
                        break;
                    }
                    case "SERVICE": {
                        serviceNameList = this.filterServiceMetadata(namespaceId, serviceNameList, factors[factors.length - 1], terms[1].replace("'", ""));
                        break;
                    }
                }
            }
        }
        if ((start = (pageNo - 1) * pageSize) < 0) {
            start = 0;
        }
        if ((end = start + pageSize) > serviceNameList.size()) {
            end = serviceNameList.size();
        }
        for (int i = start; i < end; ++i) {
            serviceNameList.set(i, serviceNameList.get(i).replace(groupName + "@@", ""));
        }
        result.replace("doms", JacksonUtils.transferToJsonNode(serviceNameList.subList(start, end)));
        result.put("count", serviceNameList.size());
        return result;
    }

    @PutMapping
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.WRITE)
    public String update(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        float protectThreshold = NumberUtils.toFloat((String)WebUtils.required((HttpServletRequest)request, (String)"protectThreshold"));
        String metadata = WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"");
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(400, "service " + serviceName + " not found!");
        }
        service.setProtectThreshold(protectThreshold);
        Map<String, String> metadataMap = UtilsAndCommons.parseMetadata(metadata);
        service.setMetadata(metadataMap);
        service.setSelector(this.parseSelector(WebUtils.optional((HttpServletRequest)request, (String)"selector", (String)"")));
        service.setLastModifiedMillis(System.currentTimeMillis());
        service.recalculateChecksum();
        service.validate();
        this.serviceManager.addOrReplaceService(service);
        return "ok";
    }

    @RequestMapping(value={"/names"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode searchService(@RequestParam(defaultValue="") String namespaceId, @RequestParam(defaultValue="") String expr, @RequestParam(required=false) boolean responsibleOnly) {
        HashMap<String, List<Service>> services = new HashMap<String, List<Service>>(16);
        if (StringUtils.isNotBlank((CharSequence)namespaceId)) {
            services.put(namespaceId, this.serviceManager.searchServices(namespaceId, ".*" + expr + ".*"));
        } else {
            for (String string : this.serviceManager.getAllNamespaces()) {
                services.put(string, this.serviceManager.searchServices(string, ".*" + expr + ".*"));
            }
        }
        HashMap serviceNameMap = new HashMap(16);
        for (String namespace : services.keySet()) {
            serviceNameMap.put(namespace, new HashSet());
            for (Service service : (List)services.get(namespace)) {
                if (!this.distroMapper.responsible(service.getName()) && responsibleOnly) continue;
                ((Set)serviceNameMap.get(namespace)).add(NamingUtils.getServiceName((String)service.getName()));
            }
        }
        ObjectNode objectNode = JacksonUtils.createEmptyJsonNode();
        objectNode.replace("services", JacksonUtils.transferToJsonNode(serviceNameMap));
        objectNode.put("count", services.size());
        return objectNode;
    }

    @PostMapping(value={"/status"})
    public String serviceStatus(HttpServletRequest request) throws Exception {
        String entity = IoUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        String value = URLDecoder.decode(entity, "UTF-8");
        JsonNode json = JacksonUtils.toObj((String)value);
        String statuses = json.get("statuses").asText();
        String serverIp = json.get("clientIP").asText();
        if (!this.memberManager.hasMember(serverIp)) {
            throw new NacosException(400, "ip: " + serverIp + " is not in serverlist");
        }
        try {
            ServiceManager.ServiceChecksum checksums = (ServiceManager.ServiceChecksum)JacksonUtils.toObj((String)statuses, ServiceManager.ServiceChecksum.class);
            if (checksums == null) {
                Loggers.SRV_LOG.warn("[DOMAIN-STATUS] receive malformed data: null");
                return "fail";
            }
            for (Map.Entry<String, String> entry : checksums.serviceName2Checksum.entrySet()) {
                if (entry == null || StringUtils.isEmpty((CharSequence)entry.getKey()) || StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                String serviceName = entry.getKey();
                String checksum = entry.getValue();
                Service service = this.serviceManager.getService(checksums.namespaceId, serviceName);
                if (service == null) continue;
                service.recalculateChecksum();
                if (checksum.equals(service.getChecksum())) continue;
                if (Loggers.SRV_LOG.isDebugEnabled()) {
                    Loggers.SRV_LOG.debug("checksum of {} is not consistent, remote: {}, checksum: {}, local: {}", new Object[]{serviceName, serverIp, checksum, service.getChecksum()});
                }
                this.serviceManager.addUpdatedServiceToQueue(checksums.namespaceId, serviceName, serverIp, checksum);
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[DOMAIN-STATUS] receive malformed data: " + statuses, (Throwable)e);
        }
        return "ok";
    }

    @PutMapping(value={"/checksum"})
    public ObjectNode checksum(HttpServletRequest request) throws Exception {
        String serviceName;
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        Service service = this.serviceManager.getService(namespaceId, serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName"));
        if (service == null) {
            throw new NacosException(404, "serviceName not found: " + serviceName);
        }
        service.recalculateChecksum();
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("checksum", service.getChecksum());
        return result;
    }

    @GetMapping(value={"/subscribers"})
    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    public ObjectNode subscribers(HttpServletRequest request) {
        int pageNo = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageNo"));
        int pageSize = NumberUtils.toInt((String)WebUtils.required((HttpServletRequest)request, (String)"pageSize"));
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        boolean aggregation = Boolean.parseBoolean(WebUtils.optional((HttpServletRequest)request, (String)"aggregation", (String)String.valueOf(Boolean.TRUE)));
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        try {
            int count;
            int end;
            List<Subscriber> subscribers = this.subscribeManager.getSubscribers(serviceName, namespaceId, aggregation);
            int start = (pageNo - 1) * pageSize;
            if (start < 0) {
                start = 0;
            }
            if ((end = start + pageSize) > (count = subscribers.size())) {
                end = count;
            }
            result.replace("subscribers", JacksonUtils.transferToJsonNode(subscribers.subList(start, end)));
            result.put("count", count);
            return result;
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("query subscribers failed!", (Throwable)e);
            result.replace("subscribers", (JsonNode)JacksonUtils.createEmptyArrayNode());
            result.put("count", 0);
            return result;
        }
    }

    private List<String> filterInstanceMetadata(String namespaceId, List<String> serviceNames, String key, String value) {
        ArrayList<String> filteredServiceNames = new ArrayList<String>();
        block0: for (String serviceName : serviceNames) {
            Service service = this.serviceManager.getService(namespaceId, serviceName);
            if (service == null) continue;
            for (Instance address : service.allIPs()) {
                if (address.getMetadata() == null || !value.equals(address.getMetadata().get(key))) continue;
                filteredServiceNames.add(serviceName);
                continue block0;
            }
        }
        return filteredServiceNames;
    }

    private List<String> filterServiceMetadata(String namespaceId, List<String> serviceNames, String key, String value) {
        ArrayList<String> filteredServices = new ArrayList<String>();
        for (String serviceName : serviceNames) {
            Service service = this.serviceManager.getService(namespaceId, serviceName);
            if (service == null || !value.equals(service.getMetadata().get(key))) continue;
            filteredServices.add(serviceName);
        }
        return filteredServices;
    }

    private Selector parseSelector(String selectorJsonString) throws Exception {
        if (StringUtils.isBlank((CharSequence)selectorJsonString)) {
            return new NoneSelector();
        }
        JsonNode selectorJson = JacksonUtils.toObj((String)URLDecoder.decode(selectorJsonString, "UTF-8"));
        switch (SelectorType.valueOf((String)selectorJson.get("type").asText())) {
            case none: {
                return new NoneSelector();
            }
            case label: {
                String expression = selectorJson.get("expression").asText();
                Set<String> labels = LabelSelector.parseExpression(expression);
                LabelSelector labelSelector = new LabelSelector();
                labelSelector.setExpression(expression);
                labelSelector.setLabels(labels);
                return labelSelector;
            }
        }
        throw new NacosException(400, "not match any type of selector!");
    }
}

