/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.healthcheck.HealthCheckStatus;
import com.alibaba.nacos.naming.misc.Loggers;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Instance
extends com.alibaba.nacos.api.naming.pojo.Instance
implements Comparable {
    private static final double MAX_WEIGHT_VALUE = 10000.0;
    private static final double MIN_POSITIVE_WEIGHT_VALUE = 0.01;
    private static final double MIN_WEIGHT_VALUE = 0.0;
    private volatile long lastBeat = System.currentTimeMillis();
    @JsonIgnore
    private volatile boolean mockValid = false;
    private volatile boolean marked = false;
    private String tenant;
    private String app;
    private static final Pattern IP_PATTERN = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):?(\\d{1,5})?");
    private static final Pattern ONLY_DIGIT_AND_DOT = Pattern.compile("(\\d|\\.)+");
    private static final String SPLITER = "_";

    public Instance() {
    }

    public boolean isMockValid() {
        return this.mockValid;
    }

    public void setMockValid(boolean mockValid) {
        this.mockValid = mockValid;
    }

    public long getLastBeat() {
        return this.lastBeat;
    }

    public void setLastBeat(long lastBeat) {
        this.lastBeat = lastBeat;
    }

    public Instance(String ip, int port) {
        this.setIp(ip);
        this.setPort(port);
        this.setClusterName("DEFAULT");
    }

    public Instance(String ip, int port, String clusterName) {
        this.setIp(ip.trim());
        this.setPort(port);
        this.setClusterName(clusterName);
    }

    public Instance(String ip, int port, String clusterName, String tenant, String app) {
        this.setIp(ip.trim());
        this.setPort(port);
        this.setClusterName(clusterName);
        this.tenant = tenant;
        this.app = app;
    }

    public static Instance fromString(String config) {
        String[] ipAddressAttributes = config.split(SPLITER);
        if (ipAddressAttributes.length < 1) {
            return null;
        }
        String provider = ipAddressAttributes[0];
        Matcher matcher = IP_PATTERN.matcher(provider);
        if (!matcher.matches()) {
            return null;
        }
        int expectedGroupCount = 2;
        int port = 0;
        if (NumberUtils.isNumber((String)matcher.group(expectedGroupCount))) {
            port = Integer.parseInt(matcher.group(expectedGroupCount));
        }
        Instance instance = new Instance(matcher.group(1), port);
        int minimumLength = 1;
        if (ipAddressAttributes.length > minimumLength) {
            instance.setWeight(NumberUtils.toDouble((String)ipAddressAttributes[minimumLength], (double)1.0));
        }
        if (ipAddressAttributes.length > ++minimumLength) {
            if (Boolean.TRUE.toString().equals(ipAddressAttributes[minimumLength]) || Boolean.FALSE.toString().equals(ipAddressAttributes[minimumLength])) {
                instance.setHealthy(Boolean.parseBoolean(ipAddressAttributes[minimumLength]));
            }
            if (!Boolean.TRUE.toString().equals(ipAddressAttributes[ipAddressAttributes.length - 1]) && !Boolean.FALSE.toString().equals(ipAddressAttributes[ipAddressAttributes.length - 1])) {
                instance.setClusterName(ipAddressAttributes[ipAddressAttributes.length - 1]);
            }
        }
        if (ipAddressAttributes.length > ++minimumLength && (Boolean.TRUE.toString().equals(ipAddressAttributes[minimumLength]) || Boolean.FALSE.toString().equals(ipAddressAttributes[minimumLength]))) {
            instance.setMarked(Boolean.parseBoolean(ipAddressAttributes[minimumLength]));
        }
        return instance;
    }

    public String toIpAddr() {
        return this.getIp() + ":" + this.getPort();
    }

    public String toString() {
        return this.getDatumKey() + SPLITER + this.getWeight() + SPLITER + this.isHealthy() + SPLITER + this.marked + SPLITER + this.getClusterName();
    }

    public String toJson() {
        return JacksonUtils.toJson((Object)this);
    }

    public static Instance fromJson(String json) {
        Instance ip;
        try {
            ip = (Instance)JacksonUtils.toObj((String)json, Instance.class);
        }
        catch (Exception e) {
            ip = Instance.fromString(json);
        }
        if (ip == null) {
            throw new IllegalArgumentException("malformed ip config: " + json);
        }
        if (ip.getWeight() > 10000.0) {
            ip.setWeight(10000.0);
        }
        if (ip.getWeight() < 0.01 && ip.getWeight() > 0.0) {
            ip.setWeight(0.01);
        } else if (ip.getWeight() < 0.0) {
            ip.setWeight(0.0);
        }
        try {
            ip.validate();
        }
        catch (NacosException e) {
            throw new IllegalArgumentException("malformed ip config: " + json);
        }
        return ip;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Instance other = (Instance)obj;
        return this.getIp().equals(other.getIp()) && (this.getPort() == other.getPort() || this.getPort() == 0) && this.isEphemeral() == other.isEphemeral();
    }

    @JsonIgnore
    public String getDatumKey() {
        if (this.getPort() > 0) {
            return this.getIp() + ":" + this.getPort() + ":" + "unknown" + ":" + this.getClusterName();
        }
        return this.getIp() + ":" + "unknown" + ":" + this.getClusterName();
    }

    @JsonIgnore
    public String getDefaultKey() {
        if (this.getPort() > 0) {
            return this.getIp() + ":" + this.getPort() + ":" + "unknown";
        }
        return this.getIp() + ":" + "unknown";
    }

    public int hashCode() {
        return this.getIp().hashCode();
    }

    public void setBeingChecked(boolean isBeingChecked) {
        HealthCheckStatus.get((Instance)this).isBeingChecked.set(isBeingChecked);
    }

    public boolean markChecking() {
        return HealthCheckStatus.get((Instance)this).isBeingChecked.compareAndSet(false, true);
    }

    @JsonIgnore
    public long getCheckRt() {
        return HealthCheckStatus.get((Instance)this).checkRt;
    }

    @JsonIgnore
    public AtomicInteger getOkCount() {
        return HealthCheckStatus.get((Instance)this).checkOkCount;
    }

    @JsonIgnore
    public AtomicInteger getFailCount() {
        return HealthCheckStatus.get((Instance)this).checkFailCount;
    }

    @JsonIgnore
    public void setCheckRt(long checkRt) {
        HealthCheckStatus.get((Instance)this).checkRt = checkRt;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean marked) {
        this.marked = marked;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String generateInstanceId() {
        return this.getIp() + "#" + this.getPort() + "#" + this.getClusterName() + "#" + this.getServiceName();
    }

    public String generateInstanceId(Set<String> currentInstanceIds) {
        String instanceIdGenerator = this.getInstanceIdGenerator();
        if ("snowflake".equalsIgnoreCase(instanceIdGenerator)) {
            return this.generateSnowflakeInstanceId(currentInstanceIds);
        }
        return this.generateInstanceId();
    }

    private String generateSnowflakeInstanceId(Set<String> currentInstanceIds) {
        int id = 0;
        while (currentInstanceIds.contains(String.valueOf(id))) {
            ++id;
        }
        String idStr = String.valueOf(id);
        currentInstanceIds.add(idStr);
        return idStr;
    }

    public void validate() throws NacosException {
        Matcher matcher;
        if (this.onlyContainsDigitAndDot() && !(matcher = IP_PATTERN.matcher(this.getIp() + ":" + this.getPort())).matches()) {
            throw new NacosException(400, "instance format invalid: Your IP address is spelled incorrectly");
        }
        if (this.getWeight() > 10000.0 || this.getWeight() < 0.0) {
            throw new NacosException(400, "instance format invalid: The weights range from 0.0 to 10000.0");
        }
    }

    private boolean onlyContainsDigitAndDot() {
        Matcher matcher = ONLY_DIGIT_AND_DOT.matcher(this.getIp());
        return matcher.matches();
    }

    public int compareTo(Object o) {
        if (!(o instanceof Instance)) {
            Loggers.SRV_LOG.error("[INSTANCE-COMPARE] Object is not an instance of IPAdress, object: {}", o.getClass());
            throw new IllegalArgumentException("Object is not an instance of IPAdress,object: " + o.getClass());
        }
        Instance instance = (Instance)o;
        String ipKey = instance.toString();
        return this.toString().compareTo(ipKey);
    }
}

