/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.healthcheck.extend.HealthCheckExtendProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="healthCheckDelegate")
public class HealthCheckProcessorDelegate
implements HealthCheckProcessor {
    private Map<String, HealthCheckProcessor> healthCheckProcessorMap = new HashMap<String, HealthCheckProcessor>();

    public HealthCheckProcessorDelegate(HealthCheckExtendProvider provider) {
        provider.init();
    }

    @Autowired
    public void addProcessor(Collection<HealthCheckProcessor> processors) {
        this.healthCheckProcessorMap.putAll(processors.stream().filter(processor -> processor.getType() != null).collect(Collectors.toMap(HealthCheckProcessor::getType, processor -> processor)));
    }

    @Override
    public void process(HealthCheckTask task) {
        String type = task.getCluster().getHealthChecker().getType();
        HealthCheckProcessor processor = this.healthCheckProcessorMap.get(type);
        if (processor == null) {
            processor = this.healthCheckProcessorMap.get("NONE");
        }
        processor.process(task);
    }

    @Override
    public String getType() {
        return null;
    }
}

