/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Http;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.healthcheck.HealthCheckCommon;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Response;
import io.netty.channel.ConnectTimeoutException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpHealthCheckProcessor
implements HealthCheckProcessor {
    public static final String TYPE = "HTTP";
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private HealthCheckCommon healthCheckCommon;
    private static AsyncHttpClient asyncHttpClient;
    private static final int CONNECT_TIMEOUT_MS = 500;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void process(HealthCheckTask task) {
        List<Instance> ips = task.getCluster().allIPs(false);
        if (CollectionUtils.isEmpty(ips)) {
            return;
        }
        if (!this.switchDomain.isHealthCheckEnabled()) {
            return;
        }
        Cluster cluster = task.getCluster();
        for (Instance ip : ips) {
            try {
                if (ip.isMarked()) {
                    if (!Loggers.SRV_LOG.isDebugEnabled()) continue;
                    Loggers.SRV_LOG.debug("http check, ip is marked as to skip health check, ip: {}" + ip.getIp());
                    continue;
                }
                if (!ip.markChecking()) {
                    Loggers.SRV_LOG.warn("http check started before last one finished, service: {}:{}:{}", new Object[]{task.getCluster().getService().getName(), task.getCluster().getName(), ip.getIp()});
                    this.healthCheckCommon.reEvaluateCheckRT(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getHttpHealthParams());
                    continue;
                }
                Http healthChecker = (Http)cluster.getHealthChecker();
                int ckPort = cluster.isUseIPPort4Check() ? ip.getPort() : cluster.getDefCkport();
                URL host = new URL("http://" + ip.getIp() + ":" + ckPort);
                URL target = new URL(host, healthChecker.getPath());
                AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareGet(target.toString());
                Map customHeaders = healthChecker.getCustomHeaders();
                for (Map.Entry entry : customHeaders.entrySet()) {
                    if ("Host".equals(entry.getKey())) {
                        builder.setVirtualHost((String)entry.getValue());
                        continue;
                    }
                    builder.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
                builder.execute((AsyncHandler)new HttpHealthCheckCallback(ip, task));
                MetricsMonitor.getHttpHealthCheckMonitor().incrementAndGet();
            }
            catch (Throwable e) {
                ip.setCheckRt(this.switchDomain.getHttpHealthParams().getMax());
                this.healthCheckCommon.checkFail(ip, task, "http:error:" + e.getMessage());
                this.healthCheckCommon.reEvaluateCheckRT(this.switchDomain.getHttpHealthParams().getMax(), task, this.switchDomain.getHttpHealthParams());
            }
        }
    }

    static {
        try {
            AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
            builder.setMaximumConnectionsTotal(-1);
            builder.setMaximumConnectionsPerHost(-1);
            builder.setAllowPoolingConnection(false);
            builder.setFollowRedirects(false);
            builder.setIdleConnectionTimeoutInMs(500);
            builder.setConnectionTimeoutInMs(500);
            builder.setCompressionEnabled(false);
            builder.setIOThreadMultiplier(1);
            builder.setMaxRequestRetry(0);
            builder.setUserAgent("VIPServer");
            asyncHttpClient = new AsyncHttpClient(builder.build());
        }
        catch (Throwable e) {
            Loggers.SRV_LOG.error("[HEALTH-CHECK] Error while constructing HTTP asynchronous client", e);
        }
    }

    private class HttpHealthCheckCallback
    extends AsyncCompletionHandler<Integer> {
        private Instance ip;
        private HealthCheckTask task;
        private long startTime = System.currentTimeMillis();

        public HttpHealthCheckCallback(Instance ip, HealthCheckTask task) {
            this.ip = ip;
            this.task = task;
        }

        public Integer onCompleted(Response response) throws Exception {
            this.ip.setCheckRt(System.currentTimeMillis() - this.startTime);
            int httpCode = response.getStatusCode();
            if (200 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkOK(this.ip, this.task, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(System.currentTimeMillis() - this.startTime, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else if (503 == httpCode || 302 == httpCode) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.ip, this.task, "http:" + httpCode);
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            }
            return httpCode;
        }

        public void onThrowable(Throwable t) {
            this.ip.setCheckRt(System.currentTimeMillis() - this.startTime);
            Throwable cause = t;
            int maxStackDepth = 50;
            for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                if (!(cause instanceof SocketTimeoutException) && !(cause instanceof ConnectTimeoutException) && !(cause instanceof org.jboss.netty.channel.ConnectTimeoutException) && !(cause instanceof TimeoutException) && !(cause.getCause() instanceof TimeoutException)) continue;
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "http:timeout:" + cause.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
                return;
            }
            if (t instanceof ConnectException) {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.ip, this.task, "http:unable2connect:" + t.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            } else {
                HttpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "http:error:" + t.getMessage());
                HttpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, HttpHealthCheckProcessor.this.switchDomain.getHttpHealthParams());
            }
        }
    }
}

