/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.core.utils.ApplicationUtils;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NamingProxy {
    private static final String DATA_ON_SYNC_URL = "/distro/datum";
    private static final String DATA_GET_URL = "/distro/datum";
    private static final String ALL_DATA_GET_URL = "/distro/datums";
    private static final String TIMESTAMP_SYNC_URL = "/distro/checksum";

    public static void syncCheckSums(Map<String, String> checksumMap, final String server) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>(128);
            headers.put("Client-Version", VersionUtils.version);
            headers.put("User-Agent", UtilsAndCommons.SERVER_VERSION);
            headers.put("Connection", "Keep-Alive");
            HttpClient.asyncHttpPutLarge("http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + TIMESTAMP_SYNC_URL + "?source=" + NetUtils.localServer(), headers, JacksonUtils.toJsonBytes(checksumMap), new AsyncCompletionHandler(){

                public Object onCompleted(Response response) throws Exception {
                    if (200 != response.getStatusCode()) {
                        Loggers.DISTRO.error("failed to req API: {}, code: {}, msg: {}", new Object[]{"http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + NamingProxy.TIMESTAMP_SYNC_URL, response.getStatusCode(), response.getResponseBody()});
                    }
                    return null;
                }

                public void onThrowable(Throwable t) {
                    Loggers.DISTRO.error("failed to req API:http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + NamingProxy.TIMESTAMP_SYNC_URL, t);
                }
            });
        }
        catch (Exception e) {
            Loggers.DISTRO.warn("NamingProxy", (Throwable)e);
        }
    }

    public static byte[] getData(List<String> keys, String server) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("keys", StringUtils.join(keys, (String)","));
        HttpClient.HttpResult result = HttpClient.httpGetLarge("http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + "/distro/datum", new HashMap<String, String>(8), JacksonUtils.toJson(params));
        if (200 == result.code) {
            return result.content.getBytes();
        }
        throw new IOException("failed to req API: http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + "/distro/datum" + ". code: " + result.code + " msg: " + result.content);
    }

    public static byte[] getAllData(String server) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>(8);
        HttpClient.HttpResult result = HttpClient.httpGet("http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + ALL_DATA_GET_URL, new ArrayList<String>(), params);
        if (200 == result.code) {
            return result.content.getBytes();
        }
        throw new IOException("failed to req API: http://" + server + ApplicationUtils.getContextPath() + "/v1/ns" + "/distro/datum" + ". code: " + result.code + " msg: " + result.content);
    }

    public static boolean syncData(byte[] data, String curServer) {
        HashMap<String, String> headers = new HashMap<String, String>(128);
        headers.put("Client-Version", VersionUtils.version);
        headers.put("User-Agent", UtilsAndCommons.SERVER_VERSION);
        headers.put("Accept-Encoding", "gzip,deflate,sdch");
        headers.put("Connection", "Keep-Alive");
        headers.put("Content-Encoding", "gzip");
        try {
            HttpClient.HttpResult result = HttpClient.httpPutLarge("http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + "/distro/datum", headers, data);
            if (200 == result.code) {
                return true;
            }
            if (304 == result.code) {
                return true;
            }
            throw new IOException("failed to req API:http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + "/distro/datum" + ". code:" + result.code + " msg: " + result.content);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return false;
        }
    }

    public static String reqApi(String api, Map<String, String> params, String curServer) throws Exception {
        try {
            List<String> headers = Arrays.asList("Client-Version", VersionUtils.version, "User-Agent", UtilsAndCommons.SERVER_VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "Content-Encoding", "gzip");
            if (!curServer.contains(":")) {
                curServer = curServer + ":" + ApplicationUtils.getPort();
            }
            HttpClient.HttpResult result = HttpClient.httpGet("http://" + curServer + api, headers, params);
            if (200 == result.code) {
                return result.content;
            }
            if (304 == result.code) {
                return "";
            }
            throw new IOException("failed to req API:http://" + curServer + api + ". code:" + result.code + " msg: " + result.content);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return "";
        }
    }

    public static String reqApi(String api, Map<String, String> params, String curServer, boolean isPost) throws Exception {
        try {
            List<String> headers = Arrays.asList("Client-Version", VersionUtils.version, "User-Agent", UtilsAndCommons.SERVER_VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "Content-Encoding", "gzip");
            if (!curServer.contains(":")) {
                curServer = curServer + ":" + ApplicationUtils.getPort();
            }
            HttpClient.HttpResult result = isPost ? HttpClient.httpPost("http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + "/api/" + api, headers, params) : HttpClient.httpGet("http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + "/api/" + api, headers, params);
            if (200 == result.code) {
                return result.content;
            }
            if (304 == result.code) {
                return "";
            }
            throw new IOException("failed to req API:http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + "/api/" + api + ". code:" + result.code + " msg: " + result.content);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return "";
        }
    }

    public static String reqCommon(String path, Map<String, String> params, String curServer, boolean isPost) throws Exception {
        try {
            List<String> headers = Arrays.asList("Client-Version", UtilsAndCommons.SERVER_VERSION, "User-Agent", UtilsAndCommons.SERVER_VERSION, "Accept-Encoding", "gzip,deflate,sdch", "Connection", "Keep-Alive", "Content-Encoding", "gzip");
            if (!curServer.contains(":")) {
                curServer = curServer + ":" + ApplicationUtils.getPort();
            }
            HttpClient.HttpResult result = isPost ? HttpClient.httpPost("http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + path, headers, params) : HttpClient.httpGet("http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + path, headers, params);
            if (200 == result.code) {
                return result.content;
            }
            if (304 == result.code) {
                return "";
            }
            throw new IOException("failed to req API:http://" + curServer + ApplicationUtils.getContextPath() + "/v1/ns" + path + ". code:" + result.code + " msg: " + result.content);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("NamingProxy", (Throwable)e);
            return "";
        }
    }

    public static class Request {
        private Map<String, String> params = new HashMap<String, String>(8);

        public static Request newRequest() {
            return new Request();
        }

        public Request appendParam(String key, String value) {
            this.params.put(key, value);
            return this;
        }

        public String toUrl() {
            StringBuilder sb = new StringBuilder();
            for (String key : this.params.keySet()) {
                sb.append(key).append("=").append(this.params.get(key)).append("&");
            }
            return sb.toString();
        }
    }
}

