/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.PersistentConsistencyService;
import com.alibaba.nacos.naming.consistency.persistent.impl.BasePersistentServiceProcessor;
import com.alibaba.nacos.naming.consistency.persistent.impl.PersistentServiceProcessor;
import com.alibaba.nacos.naming.consistency.persistent.impl.StandalonePersistentServiceProcessor;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftConsistencyServiceImpl;
import com.alibaba.nacos.naming.pojo.Record;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.springframework.stereotype.Component;

@Component(value="persistentConsistencyServiceDelegate")
public class PersistentConsistencyServiceDelegateImpl
implements PersistentConsistencyService {
    private final ClusterVersionJudgement versionJudgement;
    private final RaftConsistencyServiceImpl oldPersistentConsistencyService;
    private final BasePersistentServiceProcessor newPersistentConsistencyService;
    private volatile boolean switchNewPersistentService = false;

    public PersistentConsistencyServiceDelegateImpl(ClusterVersionJudgement versionJudgement, RaftConsistencyServiceImpl oldPersistentConsistencyService, ProtocolManager protocolManager) throws Exception {
        this.versionJudgement = versionJudgement;
        this.oldPersistentConsistencyService = oldPersistentConsistencyService;
        this.newPersistentConsistencyService = this.createNewPersistentServiceProcessor(protocolManager, versionJudgement);
        this.init();
    }

    private void init() {
        this.versionJudgement.registerObserver(isAllNewVersion -> {
            this.switchNewPersistentService = isAllNewVersion;
        }, -1);
    }

    @Override
    public void put(String key, Record value) throws NacosException {
        this.switchOne().put(key, value);
    }

    @Override
    public void remove(String key) throws NacosException {
        this.switchOne().remove(key);
    }

    @Override
    public Datum get(String key) throws NacosException {
        return this.switchOne().get(key);
    }

    @Override
    public void listen(String key, RecordListener listener) throws NacosException {
        this.oldPersistentConsistencyService.listen(key, listener);
        this.newPersistentConsistencyService.listen(key, listener);
    }

    @Override
    public void unListen(String key, RecordListener listener) throws NacosException {
        this.newPersistentConsistencyService.unListen(key, listener);
        this.oldPersistentConsistencyService.unListen(key, listener);
    }

    @Override
    public boolean isAvailable() {
        return this.switchOne().isAvailable();
    }

    private PersistentConsistencyService switchOne() {
        return this.switchNewPersistentService ? this.newPersistentConsistencyService : this.oldPersistentConsistencyService;
    }

    private BasePersistentServiceProcessor createNewPersistentServiceProcessor(ProtocolManager protocolManager, ClusterVersionJudgement versionJudgement) throws Exception {
        BasePersistentServiceProcessor processor = EnvUtil.getStandaloneMode() ? new StandalonePersistentServiceProcessor(versionJudgement) : new PersistentServiceProcessor(protocolManager, versionJudgement);
        processor.afterConstruct();
        return processor;
    }
}

