/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.impl;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.exception.KvStorageException;
import com.alibaba.nacos.core.storage.StorageFactory;
import com.alibaba.nacos.core.storage.kv.KvStorage;
import com.alibaba.nacos.core.storage.kv.MemoryKvStorage;
import com.alibaba.nacos.core.utils.TimerContext;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.misc.Loggers;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;

public class NamingKvStorage
extends MemoryKvStorage {
    private static final String LOAD_SNAPSHOT = NamingKvStorage.class.getSimpleName() + ".snapshotLoad";
    private final String baseDir;
    private final KvStorage baseDirStorage;
    private final Map<String, KvStorage> namespaceKvStorage;

    public NamingKvStorage(String baseDir) throws Exception {
        this.baseDir = baseDir;
        this.baseDirStorage = StorageFactory.createKvStorage((KvStorage.KvType)KvStorage.KvType.File, (String)"naming-persistent", (String)baseDir);
        this.namespaceKvStorage = new ConcurrentHashMap<String, KvStorage>(16);
    }

    public byte[] get(byte[] key) throws KvStorageException {
        byte[] result = super.get(key);
        if (null == result) {
            try {
                KvStorage storage = this.createActualStorageIfAbsent(key);
                byte[] byArray = result = null == storage ? null : storage.get(key);
                if (null != result) {
                    super.put(key, result);
                }
            }
            catch (Exception e) {
                throw new KvStorageException(ErrorCode.KVStorageWriteError.getCode(), "Get data failed, key: " + new String(key), (Throwable)e);
            }
        }
        return result;
    }

    public Map<byte[], byte[]> batchGet(List<byte[]> keys) throws KvStorageException {
        HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>(keys.size());
        for (byte[] key : keys) {
            byte[] val = this.get(key);
            if (val == null) continue;
            result.put(key, val);
        }
        return result;
    }

    public void put(byte[] key, byte[] value) throws KvStorageException {
        try {
            KvStorage storage = this.createActualStorageIfAbsent(key);
            storage.put(key, value);
        }
        catch (Exception e) {
            throw new KvStorageException(ErrorCode.KVStorageWriteError.getCode(), "Put data failed, key: " + new String(key), (Throwable)e);
        }
        super.put(key, value);
    }

    public void batchPut(List<byte[]> keys, List<byte[]> values) throws KvStorageException {
        if (keys.size() != values.size()) {
            throw new KvStorageException(ErrorCode.KVStorageBatchWriteError, "key's size must be equal to value's size");
        }
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            this.put(keys.get(i), values.get(i));
        }
    }

    public void delete(byte[] key) throws KvStorageException {
        try {
            KvStorage storage = this.createActualStorageIfAbsent(key);
            if (null != storage) {
                storage.delete(key);
            }
        }
        catch (Exception e) {
            throw new KvStorageException(ErrorCode.KVStorageDeleteError.getCode(), "Delete data failed, key: " + new String(key), (Throwable)e);
        }
        super.delete(key);
    }

    public void batchDelete(List<byte[]> key) throws KvStorageException {
        for (byte[] each : key) {
            this.delete(each);
        }
    }

    public void doSnapshot(String backupPath) throws KvStorageException {
        this.baseDirStorage.doSnapshot(backupPath);
    }

    public void snapshotLoad(String path) throws KvStorageException {
        TimerContext.start((String)LOAD_SNAPSHOT);
        try {
            this.baseDirStorage.snapshotLoad(path);
            this.loadSnapshotFromActualStorage(this.baseDirStorage);
            this.loadNamespaceSnapshot();
        }
        finally {
            TimerContext.end((String)LOAD_SNAPSHOT, (Logger)Loggers.RAFT);
        }
    }

    private void loadSnapshotFromActualStorage(KvStorage actualStorage) throws KvStorageException {
        for (byte[] each : actualStorage.allKeys()) {
            byte[] datum = actualStorage.get(each);
            super.put(each, datum);
        }
    }

    private void loadNamespaceSnapshot() {
        for (String each : this.getAllNamespaceDirs()) {
            try {
                KvStorage kvStorage = this.createActualStorageIfAbsent(each);
                this.loadSnapshotFromActualStorage(kvStorage);
            }
            catch (Exception e) {
                Loggers.RAFT.error("load snapshot for namespace {} failed", (Object)each, (Object)e);
            }
        }
    }

    private List<String> getAllNamespaceDirs() {
        File[] files = new File(this.baseDir).listFiles();
        List result = Collections.emptyList();
        if (null != files) {
            result = new ArrayList(files.length);
            for (File each : files) {
                if (!each.isDirectory()) continue;
                result.add(each.getName());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<byte[]> allKeys() throws KvStorageException {
        return super.allKeys();
    }

    public void shutdown() {
        this.baseDirStorage.shutdown();
        for (KvStorage each : this.namespaceKvStorage.values()) {
            each.shutdown();
        }
        this.namespaceKvStorage.clear();
        super.shutdown();
    }

    private KvStorage createActualStorageIfAbsent(byte[] key) throws Exception {
        String keyString = new String(key);
        String namespace = KeyBuilder.getNamespace(keyString);
        return this.createActualStorageIfAbsent(namespace);
    }

    private KvStorage createActualStorageIfAbsent(String namespace) throws Exception {
        if (StringUtils.isBlank((String)namespace)) {
            return this.baseDirStorage;
        }
        Function<String, KvStorage> kvStorageBuilder = key -> {
            try {
                String namespacePath = Paths.get(this.baseDir, key).toString();
                return StorageFactory.createKvStorage((KvStorage.KvType)KvStorage.KvType.File, (String)"naming-persistent", (String)namespacePath);
            }
            catch (Exception e) {
                throw new NacosRuntimeException(500, (Throwable)e);
            }
        };
        this.namespaceKvStorage.computeIfAbsent(namespace, kvStorageBuilder);
        return this.namespaceKvStorage.get(namespace);
    }
}

