/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.ValueChangeEvent;
import com.alibaba.nacos.naming.consistency.persistent.PersistentNotifier;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.pojo.Record;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class RaftStore
implements Closeable {
    private final Properties meta = new Properties();
    private static final String META_FILE_NAME = UtilsAndCommons.DATA_BASE_DIR + File.separator + "meta.properties";
    private static final String CACHE_DIR = UtilsAndCommons.DATA_BASE_DIR + File.separator + "data";

    public synchronized void loadDatums(PersistentNotifier notifier, Map<String, Datum> datums) throws Exception {
        long start = System.currentTimeMillis();
        for (File cache : this.listCaches()) {
            Datum datum;
            if (cache.isDirectory() && cache.listFiles() != null) {
                for (File datumFile : cache.listFiles()) {
                    datum = this.readDatum(datumFile, cache.getName());
                    if (datum == null) continue;
                    datums.put(datum.key, datum);
                    if (notifier == null) continue;
                    NotifyCenter.publishEvent((Event)ValueChangeEvent.builder().key(datum.key).action(DataOperation.CHANGE).build());
                }
                continue;
            }
            datum = this.readDatum(cache, "");
            if (datum == null) continue;
            datums.put(datum.key, datum);
        }
        Loggers.RAFT.info("finish loading all datums, size: {} cost {} ms.", (Object)datums.size(), (Object)(System.currentTimeMillis() - start));
    }

    public synchronized Properties loadMeta() throws Exception {
        File metaFile = new File(META_FILE_NAME);
        if (!(metaFile.exists() || metaFile.getParentFile().mkdirs() || metaFile.createNewFile())) {
            throw new IllegalStateException("failed to create meta file: " + metaFile.getAbsolutePath());
        }
        try (FileInputStream inStream = new FileInputStream(metaFile);){
            this.meta.load(inStream);
        }
        return this.meta;
    }

    public synchronized Datum load(String key) throws Exception {
        long start = System.currentTimeMillis();
        for (File cache : this.listCaches()) {
            if (!cache.isFile()) {
                Loggers.RAFT.warn("warning: encountered directory in cache dir: {}", (Object)cache.getAbsolutePath());
            }
            if (!StringUtils.equals((CharSequence)cache.getName(), (CharSequence)RaftStore.encodeDatumKey(key))) continue;
            Loggers.RAFT.info("finish loading datum, key: {} cost {} ms.", (Object)key, (Object)(System.currentTimeMillis() - start));
            return this.readDatum(cache, "");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Datum readDatum(File file, String namespaceId) throws IOException {
        if (!KeyBuilder.isDatumCacheFile(file.getName())) {
            return null;
        }
        try (FileChannel fc = new FileInputStream(file).getChannel();){
            ByteBuffer buffer = ByteBuffer.allocate((int)file.length());
            fc.read(buffer);
            String json = new String(buffer.array(), StandardCharsets.UTF_8);
            if (StringUtils.isBlank((CharSequence)json)) {
                Datum datum = null;
                return datum;
            }
            String fileName = file.getName();
            if (KeyBuilder.matchSwitchKey(fileName)) {
                Datum datum = (Datum)JacksonUtils.toObj((String)json, (TypeReference)new TypeReference<Datum<SwitchDomain>>(){});
                return datum;
            }
            if (KeyBuilder.matchServiceMetaKey(fileName)) {
                Datum serviceDatum;
                try {
                    serviceDatum = (Datum)JacksonUtils.toObj((String)json.replace("\\", ""), (TypeReference)new TypeReference<Datum<Service>>(){});
                }
                catch (Exception e) {
                    JsonNode jsonObject = JacksonUtils.toObj((String)json);
                    serviceDatum = new Datum();
                    serviceDatum.timestamp.set(jsonObject.get("timestamp").asLong());
                    serviceDatum.key = jsonObject.get("key").asText();
                    serviceDatum.value = (Record)JacksonUtils.toObj((String)jsonObject.get("value").toString(), Service.class);
                }
                if (StringUtils.isBlank((CharSequence)((Service)serviceDatum.value).getGroupName())) {
                    ((Service)serviceDatum.value).setGroupName("DEFAULT_GROUP");
                }
                if (!((Service)serviceDatum.value).getName().contains("@@")) {
                    ((Service)serviceDatum.value).setName("DEFAULT_GROUP@@" + ((Service)serviceDatum.value).getName());
                }
                Datum e = serviceDatum;
                return e;
            }
            if (KeyBuilder.matchInstanceListKey(fileName)) {
                Datum instancesDatum;
                block38: {
                    try {
                        instancesDatum = (Datum)JacksonUtils.toObj((String)json, (TypeReference)new TypeReference<Datum<Instances>>(){});
                    }
                    catch (Exception e) {
                        JsonNode jsonObject = JacksonUtils.toObj((String)json);
                        instancesDatum = new Datum();
                        instancesDatum.timestamp.set(jsonObject.get("timestamp").asLong());
                        String key = jsonObject.get("key").asText();
                        String serviceName = KeyBuilder.getServiceName(key);
                        instancesDatum.key = key = key.substring(0, key.indexOf(serviceName)) + "DEFAULT_GROUP" + "@@" + serviceName;
                        instancesDatum.value = new Instances();
                        ((Instances)instancesDatum.value).setInstanceList((List)JacksonUtils.toObj((String)jsonObject.get("value").toString(), (TypeReference)new TypeReference<List<Instance>>(){}));
                        if (((Instances)instancesDatum.value).getInstanceList().isEmpty()) break block38;
                        for (Instance instance : ((Instances)instancesDatum.value).getInstanceList()) {
                            instance.setEphemeral(false);
                        }
                    }
                }
                Datum datum = instancesDatum;
                return datum;
            }
            Datum datum = (Datum)JacksonUtils.toObj((String)json, Datum.class);
            return datum;
        }
        catch (Exception e) {
            Loggers.RAFT.warn("waning: failed to deserialize key: {}", (Object)file.getName());
            throw e;
        }
    }

    private String cacheFileName(String namespaceId, String datumKey) {
        String fileName = StringUtils.isNotBlank((CharSequence)namespaceId) ? CACHE_DIR + File.separator + namespaceId + File.separator + RaftStore.encodeDatumKey(datumKey) : CACHE_DIR + File.separator + RaftStore.encodeDatumKey(datumKey);
        return fileName;
    }

    public synchronized void write(Datum datum) throws Exception {
        String oldDatumKey;
        String namespaceId = KeyBuilder.getNamespace(datum.key);
        File cacheFile = new File(this.cacheFileName(namespaceId, datum.key));
        if (!(cacheFile.exists() || cacheFile.getParentFile().mkdirs() || cacheFile.createNewFile())) {
            MetricsMonitor.getDiskException().increment();
            throw new IllegalStateException("can not make cache file: " + cacheFile.getName());
        }
        ByteBuffer data = ByteBuffer.wrap(JacksonUtils.toJson((Object)datum).getBytes(StandardCharsets.UTF_8));
        try (FileChannel fc = new FileOutputStream(cacheFile, false).getChannel();){
            fc.write(data, data.position());
            fc.force(true);
        }
        catch (Exception e) {
            MetricsMonitor.getDiskException().increment();
            throw e;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{namespaceId}) && datum.key.contains("DEFAULT_GROUP@@") && (cacheFile = new File(this.cacheFileName(namespaceId, oldDatumKey = datum.key.replace("DEFAULT_GROUP@@", "")))).exists() && !cacheFile.delete()) {
            Loggers.RAFT.error("[RAFT-DELETE] failed to delete old format datum: {}, value: {}", (Object)datum.key, datum.value);
            throw new IllegalStateException("failed to delete old format datum: " + datum.key);
        }
    }

    private File[] listCaches() throws Exception {
        File cacheDir = new File(CACHE_DIR);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IllegalStateException("cloud not make out directory: " + cacheDir.getName());
        }
        return cacheDir.listFiles();
    }

    public void delete(Datum datum) {
        File cacheFile;
        String namespaceId = KeyBuilder.getNamespace(datum.key);
        if (StringUtils.isNotBlank((CharSequence)namespaceId) && (cacheFile = new File(this.cacheFileName(namespaceId, datum.key))).exists() && !cacheFile.delete()) {
            Loggers.RAFT.error("[RAFT-DELETE] failed to delete datum: {}, value: {}", (Object)datum.key, datum.value);
            throw new IllegalStateException("failed to delete datum: " + datum.key);
        }
    }

    public void updateTerm(long term) throws Exception {
        File file = new File(META_FILE_NAME);
        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
            throw new IllegalStateException("failed to create meta file");
        }
        try (FileOutputStream outStream = new FileOutputStream(file);){
            this.meta.setProperty("term", String.valueOf(term));
            this.meta.store(outStream, null);
        }
    }

    private static String encodeDatumKey(String datumKey) {
        return datumKey.replace(':', '#');
    }

    private static String decodeDatumKey(String datumKey) {
        return datumKey.replace("#", ":");
    }

    public void shutdown() throws NacosException {
    }
}

