/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.pojo.ClusterInfo;
import com.alibaba.nacos.naming.pojo.IpAddressInfo;
import com.alibaba.nacos.naming.pojo.ServiceDetailInfo;
import com.alibaba.nacos.naming.pojo.ServiceView;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/catalog"})
public class CatalogController {
    @Autowired
    protected ServiceManager serviceManager;

    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    @GetMapping(value={"/service"})
    public ObjectNode serviceDetail(@RequestParam(defaultValue="public") String namespaceId, String serviceName) throws NacosException {
        Service detailedService = this.serviceManager.getService(namespaceId, serviceName);
        if (detailedService == null) {
            throw new NacosException(404, "service " + serviceName + " is not found!");
        }
        ObjectNode serviceObject = JacksonUtils.createEmptyJsonNode();
        serviceObject.put("name", NamingUtils.getServiceName((String)serviceName));
        serviceObject.put("protectThreshold", detailedService.getProtectThreshold());
        serviceObject.put("groupName", NamingUtils.getGroupName((String)serviceName));
        serviceObject.replace("selector", JacksonUtils.transferToJsonNode((Object)detailedService.getSelector()));
        serviceObject.replace("metadata", JacksonUtils.transferToJsonNode((Object)detailedService.getMetadata()));
        ObjectNode detailView = JacksonUtils.createEmptyJsonNode();
        detailView.replace("service", (JsonNode)serviceObject);
        detailView.replace("clusters", JacksonUtils.transferToJsonNode(detailedService.getClusterMap().values()));
        return detailView;
    }

    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    @RequestMapping(value={"/instances"})
    public ObjectNode instanceList(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam String clusterName, @RequestParam(name="pageNo") int page, @RequestParam int pageSize) throws NacosException {
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(404, "serivce " + serviceName + " is not found!");
        }
        if (!service.getClusterMap().containsKey(clusterName)) {
            throw new NacosException(404, "cluster " + clusterName + " is not found!");
        }
        List<Instance> instances = service.getClusterMap().get(clusterName).allIPs();
        int start = (page - 1) * pageSize;
        int end = page * pageSize;
        if (start < 0) {
            start = 0;
        }
        if (start > instances.size()) {
            start = instances.size();
        }
        if (end > instances.size()) {
            end = instances.size();
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.replace("list", JacksonUtils.transferToJsonNode(instances.subList(start, end)));
        result.put("count", instances.size());
        return result;
    }

    @Secured(parser=NamingResourceParser.class, action=ActionTypes.READ)
    @GetMapping(value={"/services"})
    public Object listDetail(@RequestParam(required=false) boolean withInstances, @RequestParam(defaultValue="public") String namespaceId, @RequestParam(required=false) int pageNo, @RequestParam(required=false) int pageSize, @RequestParam(name="serviceNameParam", defaultValue="") String serviceName, @RequestParam(name="groupNameParam", defaultValue="") String groupName, @RequestParam(name="instance", defaultValue="") String containedInstance, @RequestParam(required=false) boolean hasIpCount) {
        String param;
        String string = param = StringUtils.isBlank((CharSequence)serviceName) && StringUtils.isBlank((CharSequence)groupName) ? "" : NamingUtils.getGroupedNameOptional((String)serviceName, (String)groupName);
        if (withInstances) {
            ArrayList<ServiceDetailInfo> serviceDetailInfoList = new ArrayList<ServiceDetailInfo>();
            ArrayList<Service> services = new ArrayList<Service>(8);
            this.serviceManager.getPagedService(namespaceId, pageNo, pageSize, param, "", services, false);
            for (Service service : services) {
                ServiceDetailInfo serviceDetailInfo = new ServiceDetailInfo();
                serviceDetailInfo.setServiceName(NamingUtils.getServiceName((String)service.getName()));
                serviceDetailInfo.setGroupName(NamingUtils.getGroupName((String)service.getName()));
                serviceDetailInfo.setMetadata(service.getMetadata());
                Map<String, ClusterInfo> clusterInfoMap = this.getStringClusterInfoMap(service);
                serviceDetailInfo.setClusterMap(clusterInfoMap);
                serviceDetailInfoList.add(serviceDetailInfo);
            }
            return serviceDetailInfoList;
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayList<Service> services = new ArrayList<Service>();
        int total = this.serviceManager.getPagedService(namespaceId, pageNo - 1, pageSize, param, containedInstance, services, hasIpCount);
        if (CollectionUtils.isEmpty(services)) {
            result.replace("serviceList", JacksonUtils.transferToJsonNode(Collections.emptyList()));
            result.put("count", 0);
            return result;
        }
        LinkedList<ServiceView> serviceViews = new LinkedList<ServiceView>();
        for (Service service : services) {
            ServiceView serviceView = new ServiceView();
            serviceView.setName(NamingUtils.getServiceName((String)service.getName()));
            serviceView.setGroupName(NamingUtils.getGroupName((String)service.getName()));
            serviceView.setClusterCount(service.getClusterMap().size());
            serviceView.setIpCount(service.allIPs().size());
            serviceView.setHealthyInstanceCount(service.healthyInstanceCount());
            serviceView.setTriggerFlag(service.triggerFlag() ? "true" : "false");
            serviceViews.add(serviceView);
        }
        result.replace("serviceList", JacksonUtils.transferToJsonNode(serviceViews));
        result.put("count", total);
        return result;
    }

    @RequestMapping(value={"/rt/service"})
    public ObjectNode rt4Service(HttpServletRequest request) {
        String serviceName;
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        Service service = this.serviceManager.getService(namespaceId, serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName"));
        if (service == null) {
            throw new IllegalArgumentException("request service doesn't exist");
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        ArrayNode clusters = JacksonUtils.createEmptyArrayNode();
        for (Map.Entry<String, Cluster> entry : service.getClusterMap().entrySet()) {
            ObjectNode packet = JacksonUtils.createEmptyJsonNode();
            HealthCheckTask task = entry.getValue().getHealthCheckTask();
            packet.put("name", entry.getKey());
            packet.put("checkRTBest", task.getCheckRtBest());
            packet.put("checkRTWorst", task.getCheckRtWorst());
            packet.put("checkRTNormalized", task.getCheckRtNormalized());
            clusters.add((JsonNode)packet);
        }
        result.replace("clusters", (JsonNode)clusters);
        return result;
    }

    private Map<String, ClusterInfo> getStringClusterInfoMap(Service service) {
        HashMap<String, ClusterInfo> clusterInfoMap = new HashMap<String, ClusterInfo>(8);
        service.getClusterMap().forEach((clusterName, cluster) -> {
            ClusterInfo clusterInfo = new ClusterInfo();
            List<IpAddressInfo> ipAddressInfos = this.getIpAddressInfos(cluster.allIPs());
            clusterInfo.setHosts(ipAddressInfos);
            clusterInfoMap.put((String)clusterName, clusterInfo);
        });
        return clusterInfoMap;
    }

    private List<IpAddressInfo> getIpAddressInfos(List<Instance> instances) {
        ArrayList<IpAddressInfo> ipAddressInfos = new ArrayList<IpAddressInfo>();
        instances.forEach(ipAddress -> {
            IpAddressInfo ipAddressInfo = new IpAddressInfo();
            ipAddressInfo.setIp(ipAddress.getIp());
            ipAddressInfo.setPort(ipAddress.getPort());
            ipAddressInfo.setMetadata(ipAddress.getMetadata());
            ipAddressInfo.setValid(ipAddress.isHealthy());
            ipAddressInfo.setWeight(ipAddress.getWeight());
            ipAddressInfo.setEnabled(ipAddress.isEnabled());
            ipAddressInfos.add(ipAddressInfo);
        });
        return ipAddressInfos;
    }
}

