/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckerFactory;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/cluster"})
public class ClusterController {
    @Autowired
    protected ServiceManager serviceManager;

    @PutMapping
    @Secured(action=ActionTypes.WRITE, parser=NamingResourceParser.class)
    public String update(HttpServletRequest request) throws Exception {
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String clusterName = WebUtils.required((HttpServletRequest)request, (String)"clusterName");
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String checkPort = WebUtils.required((HttpServletRequest)request, (String)"checkPort");
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (service == null) {
            throw new NacosException(400, "service not found:" + serviceName);
        }
        Cluster cluster = service.getClusterMap().get(clusterName);
        if (cluster == null) {
            Loggers.SRV_LOG.warn("[UPDATE-CLUSTER] cluster not exist, will create it: {}, service: {}", (Object)clusterName, (Object)serviceName);
            cluster = new Cluster(clusterName, service);
        }
        cluster.setDefCkport(NumberUtils.toInt((String)checkPort));
        cluster.setUseIPPort4Check(BooleanUtils.toBoolean((String)WebUtils.required((HttpServletRequest)request, (String)"useInstancePort4Check")));
        AbstractHealthChecker abstractHealthChecker = HealthCheckerFactory.deserialize((String)WebUtils.required((HttpServletRequest)request, (String)"healthChecker"));
        cluster.setHealthChecker(abstractHealthChecker);
        cluster.setMetadata(UtilsAndCommons.parseMetadata(WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"")));
        cluster.init();
        service.getClusterMap().put(clusterName, cluster);
        service.setLastModifiedMillis(System.currentTimeMillis());
        service.recalculateChecksum();
        service.validate();
        this.serviceManager.addOrReplaceService(service);
        return "ok";
    }
}

