/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.api.naming.pojo.healthcheck.impl.Mysql;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.healthcheck.HealthCheckCommon;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import io.netty.channel.ConnectTimeoutException;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MysqlHealthCheckProcessor
implements HealthCheckProcessor {
    public static final String TYPE = "MYSQL";
    @Autowired
    private HealthCheckCommon healthCheckCommon;
    @Autowired
    private SwitchDomain switchDomain;
    public static final int CONNECT_TIMEOUT_MS = 500;
    private static final String CHECK_MYSQL_MASTER_SQL = "show global variables where variable_name='read_only'";
    private static final String MYSQL_SLAVE_READONLY = "ON";
    private static final ConcurrentMap<String, Connection> CONNECTION_POOL = new ConcurrentHashMap<String, Connection>();

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void process(HealthCheckTask task) {
        List<Instance> ips = task.getCluster().allIPs(false);
        Loggers.SRV_LOG.debug("mysql check, ips:" + ips);
        if (CollectionUtils.isEmpty(ips)) {
            return;
        }
        for (Instance ip : ips) {
            try {
                if (ip.isMarked()) {
                    if (!Loggers.SRV_LOG.isDebugEnabled()) continue;
                    Loggers.SRV_LOG.debug("mysql check, ip is marked as to skip health check, ip: {}", (Object)ip.getIp());
                    continue;
                }
                if (!ip.markChecking()) {
                    Loggers.SRV_LOG.warn("mysql check started before last one finished, service: {}:{}:{}", new Object[]{task.getCluster().getService().getName(), task.getCluster().getName(), ip.getIp()});
                    this.healthCheckCommon.reEvaluateCheckRT(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getMysqlHealthParams());
                    continue;
                }
                GlobalExecutor.executeMysqlCheckTask(new MysqlCheckTask(ip, task));
                MetricsMonitor.getMysqlHealthCheckMonitor().incrementAndGet();
            }
            catch (Exception e) {
                ip.setCheckRt(this.switchDomain.getMysqlHealthParams().getMax());
                this.healthCheckCommon.checkFail(ip, task, "mysql:error:" + e.getMessage());
                this.healthCheckCommon.reEvaluateCheckRT(this.switchDomain.getMysqlHealthParams().getMax(), task, this.switchDomain.getMysqlHealthParams());
            }
        }
    }

    private class MysqlCheckTask
    implements Runnable {
        private Instance ip;
        private HealthCheckTask task;
        private long startTime = System.currentTimeMillis();

        public MysqlCheckTask(Instance ip, HealthCheckTask task) {
            this.ip = ip;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Cluster cluster = this.task.getCluster();
                String key = cluster.getService().getName() + ":" + cluster.getName() + ":" + this.ip.getIp() + ":" + this.ip.getPort();
                Connection connection = (Connection)CONNECTION_POOL.get(key);
                Mysql config = (Mysql)cluster.getHealthChecker();
                if (connection == null || connection.isClosed()) {
                    String url = "jdbc:mysql://" + this.ip.getIp() + ":" + this.ip.getPort() + "?connectTimeout=" + 500 + "&socketTimeout=" + 500 + "&loginTimeout=" + 1;
                    connection = DriverManager.getConnection(url, config.getUser(), config.getPwd());
                    CONNECTION_POOL.put(key, connection);
                }
                statement = connection.createStatement();
                statement.setQueryTimeout(1);
                resultSet = statement.executeQuery(config.getCmd());
                int resultColumnIndex = 2;
                if (MysqlHealthCheckProcessor.CHECK_MYSQL_MASTER_SQL.equals(config.getCmd())) {
                    resultSet.next();
                    if (MysqlHealthCheckProcessor.MYSQL_SLAVE_READONLY.equals(resultSet.getString(resultColumnIndex))) {
                        throw new IllegalStateException("current node is slave!");
                    }
                }
                MysqlHealthCheckProcessor.this.healthCheckCommon.checkOK(this.ip, this.task, "mysql:+ok");
                MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(System.currentTimeMillis() - this.startTime, this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
            }
            catch (SQLException e) {
                MysqlHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.ip, this.task, "mysql:" + e.getMessage());
                MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(MysqlHealthCheckProcessor.this.switchDomain.getHttpHealthParams().getMax(), this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
            }
            catch (Throwable t) {
                Throwable cause = t;
                int maxStackDepth = 50;
                for (int deepth = 0; deepth < maxStackDepth && cause != null; cause = cause.getCause(), ++deepth) {
                    if (!(cause instanceof SocketTimeoutException) && !(cause instanceof ConnectTimeoutException) && !(cause instanceof TimeoutException) && !(cause.getCause() instanceof TimeoutException)) continue;
                    MysqlHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "mysql:timeout:" + cause.getMessage());
                    MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(this.task.getCheckRtNormalized() * 2L, this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
                    return;
                }
                MysqlHealthCheckProcessor.this.healthCheckCommon.checkFail(this.ip, this.task, "mysql:error:" + t.getMessage());
                MysqlHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRT(MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams().getMax(), this.task, MysqlHealthCheckProcessor.this.switchDomain.getMysqlHealthParams());
            }
            finally {
                this.ip.setCheckRt(System.currentTimeMillis() - this.startTime);
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        Loggers.SRV_LOG.error("[MYSQL-CHECK] failed to close statement:" + statement, (Throwable)e);
                    }
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        Loggers.SRV_LOG.error("[MYSQL-CHECK] failed to close resultSet:" + resultSet, (Throwable)e);
                    }
                }
            }
        }
    }
}

