/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.common.http.AbstractApacheHttpClientFactory;
import com.alibaba.nacos.common.http.AbstractHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosAsyncRestTemplate;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class HttpClientManager {
    private static final int TIME_OUT_MILLIS = 10000;
    private static final int CON_TIME_OUT_MILLIS = 5000;
    private static final HttpClientFactory SYNC_HTTP_CLIENT_FACTORY = new SyncHttpClientFactory();
    private static final HttpClientFactory ASYNC_HTTP_CLIENT_FACTORY = new AsyncHttpClientFactory();
    private static final HttpClientFactory PROCESSOR_ASYNC_HTTP_CLIENT_FACTORY = new ProcessorHttpClientFactory();
    private static final HttpClientFactory APACHE_SYNC_HTTP_CLIENT_FACTORY = new ApacheSyncHttpClientFactory();
    private static final NacosRestTemplate NACOS_REST_TEMPLATE = HttpClientBeanHolder.getNacosRestTemplate((HttpClientFactory)SYNC_HTTP_CLIENT_FACTORY);
    private static final NacosRestTemplate APACHE_NACOS_REST_TEMPLATE = HttpClientBeanHolder.getNacosRestTemplate((HttpClientFactory)APACHE_SYNC_HTTP_CLIENT_FACTORY);
    private static final NacosAsyncRestTemplate NACOS_ASYNC_REST_TEMPLATE = HttpClientBeanHolder.getNacosAsyncRestTemplate((HttpClientFactory)ASYNC_HTTP_CLIENT_FACTORY);
    private static final NacosAsyncRestTemplate PROCESSOR_NACOS_ASYNC_REST_TEMPLATE = HttpClientBeanHolder.getNacosAsyncRestTemplate((HttpClientFactory)PROCESSOR_ASYNC_HTTP_CLIENT_FACTORY);

    public static NacosRestTemplate getNacosRestTemplate() {
        return NACOS_REST_TEMPLATE;
    }

    public static NacosRestTemplate getApacheRestTemplate() {
        return APACHE_NACOS_REST_TEMPLATE;
    }

    public static NacosAsyncRestTemplate getAsyncRestTemplate() {
        return NACOS_ASYNC_REST_TEMPLATE;
    }

    public static NacosAsyncRestTemplate getProcessorNacosAsyncRestTemplate() {
        return PROCESSOR_NACOS_ASYNC_REST_TEMPLATE;
    }

    private static void shutdown() {
        Loggers.SRV_LOG.warn("[NamingServerHttpClientManager] Start destroying HTTP-Client");
        try {
            HttpClientBeanHolder.shutdownNacostSyncRest((String)SYNC_HTTP_CLIENT_FACTORY.getClass().getName());
            HttpClientBeanHolder.shutdownNacostSyncRest((String)APACHE_SYNC_HTTP_CLIENT_FACTORY.getClass().getName());
            HttpClientBeanHolder.shutdownNacosAsyncRest((String)ASYNC_HTTP_CLIENT_FACTORY.getClass().getName());
            HttpClientBeanHolder.shutdownNacosAsyncRest((String)PROCESSOR_ASYNC_HTTP_CLIENT_FACTORY.getClass().getName());
        }
        catch (Exception ex) {
            Loggers.SRV_LOG.error("[NamingServerHttpClientManager] An exception occurred when the HTTP client was closed : {}", (Object)ExceptionUtil.getStackTrace((Throwable)ex));
        }
        Loggers.SRV_LOG.warn("[NamingServerHttpClientManager] Destruction of the end");
    }

    static {
        ThreadUtils.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                HttpClientManager.shutdown();
            }
        });
    }

    private static class ProcessorHttpClientFactory
    extends AbstractHttpClientFactory {
        private ProcessorHttpClientFactory() {
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConnectionRequestTimeout(500).setReadTimeOutMillis(500).setConTimeOutMillis(500).setIoThreadCount(1).setContentCompressionEnabled(false).setMaxRedirects(0).setMaxConnTotal(-1).setMaxConnPerRoute(-1).setUserAgent("VIPServer").build();
        }

        protected Logger assignLogger() {
            return Loggers.SRV_LOG;
        }
    }

    private static class ApacheSyncHttpClientFactory
    extends AbstractApacheHttpClientFactory {
        private ApacheSyncHttpClientFactory() {
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConnectionTimeToLive(500L, TimeUnit.MILLISECONDS).setMaxConnTotal(Runtime.getRuntime().availableProcessors() * 2).setMaxConnPerRoute(Runtime.getRuntime().availableProcessors()).setMaxRedirects(0).build();
        }

        protected Logger assignLogger() {
            return Loggers.SRV_LOG;
        }
    }

    private static class SyncHttpClientFactory
    extends AbstractHttpClientFactory {
        private SyncHttpClientFactory() {
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConTimeOutMillis(5000).setReadTimeOutMillis(10000).setMaxRedirects(0).build();
        }

        protected Logger assignLogger() {
            return Loggers.SRV_LOG;
        }
    }

    private static class AsyncHttpClientFactory
    extends AbstractHttpClientFactory {
        private AsyncHttpClientFactory() {
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConTimeOutMillis(5000).setReadTimeOutMillis(10000).setUserAgent(UtilsAndCommons.SERVER_VERSION).setMaxConnTotal(-1).setMaxConnPerRoute(128).setMaxRedirects(0).build();
        }

        protected Logger assignLogger() {
            return Loggers.SRV_LOG;
        }
    }
}

