/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.columnar.datatypes;

import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.util.MemoryUtil;
import java.nio.ByteBuffer;

public class AutoGrowByteBuffer {
    private final ByteBuffer initBuf;
    private ByteBuffer buf;

    public AutoGrowByteBuffer(ByteBuffer initBuf) {
        initBuf.clear();
        this.initBuf = initBuf;
        this.buf = initBuf;
    }

    public int dataSize() {
        return this.buf.position();
    }

    public ByteBuffer getByteBuffer() {
        return this.buf;
    }

    private void beforeIncrease(int inc) {
        int minCap = this.buf.position() + inc;
        if (minCap > this.buf.capacity()) {
            int newCap = this.buf.capacity();
            while (minCap > (newCap <<= 1)) {
            }
            ByteBuffer newBuf = MemoryUtil.allocateDirect(newCap);
            MemoryUtil.copyMemory(MemoryUtil.getAddress(this.buf), MemoryUtil.getAddress(newBuf), this.buf.position());
            newBuf.position(this.buf.position());
            if (this.buf != this.initBuf) {
                MemoryUtil.free(this.buf);
            }
            this.buf = newBuf;
        }
    }

    public void put(CodecDataInput cdi, int len) {
        this.beforeIncrease(len);
        this.buf.limit(this.buf.position() + len);
        MemoryUtil.readFully(this.buf, cdi, len);
    }

    public void putByte(byte v) {
        this.beforeIncrease(1);
        this.buf.limit(this.buf.position() + 1);
        this.buf.put(v);
    }
}

