/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.base.Joiner;
import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.types.DataType;
import java.util.List;
import java.util.Objects;

public class AggregateFunction
extends Expression {
    private final FunctionType type;
    private final Expression argument;

    private AggregateFunction(FunctionType type, Expression argument, DataType dataType) {
        super(dataType);
        this.type = Objects.requireNonNull(type, "function type is null");
        this.argument = Objects.requireNonNull(argument, "function argument is null");
    }

    public static AggregateFunction newCall(FunctionType type, Expression argument) {
        return AggregateFunction.newCall(type, argument, argument.dataType);
    }

    public static AggregateFunction newCall(FunctionType type, Expression argument, DataType dataType) {
        return new AggregateFunction(type, argument, dataType);
    }

    public FunctionType getType() {
        return this.type;
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.argument);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggregateFunction)) {
            return false;
        }
        AggregateFunction that = (AggregateFunction)other;
        return this.type == that.type && Objects.equals(this.argument, that.argument);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.argument});
    }

    public String toString() {
        return String.format("%s(%s)", new Object[]{this.getType(), Joiner.on(",").useForNull("NULL").join(this.getChildren())});
    }

    public static enum FunctionType {
        Sum,
        Count,
        Min,
        Max,
        First;

    }
}

