/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.exception.TiExpressionException;
import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import java.util.List;
import java.util.Objects;

public class ComparisonBinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final Operator compOperator;
    private transient NormalizedPredicate normalizedPredicate;

    public ComparisonBinaryExpression(Operator operator, Expression left, Expression right) {
        super(IntegerType.BOOLEAN);
        this.resolved = true;
        this.left = Objects.requireNonNull(left, "left expression is null");
        this.right = Objects.requireNonNull(right, "right expression is null");
        this.compOperator = Objects.requireNonNull(operator, "type is null");
    }

    public static ComparisonBinaryExpression equal(Expression left, Expression right) {
        return new ComparisonBinaryExpression(Operator.EQUAL, left, right);
    }

    public static ComparisonBinaryExpression notEqual(Expression left, Expression right) {
        return new ComparisonBinaryExpression(Operator.NOT_EQUAL, left, right);
    }

    public static ComparisonBinaryExpression lessThan(Expression left, Expression right) {
        return new ComparisonBinaryExpression(Operator.LESS_THAN, left, right);
    }

    public static ComparisonBinaryExpression lessEqual(Expression left, Expression right) {
        return new ComparisonBinaryExpression(Operator.LESS_EQUAL, left, right);
    }

    public static ComparisonBinaryExpression greaterThan(Expression left, Expression right) {
        return new ComparisonBinaryExpression(Operator.GREATER_THAN, left, right);
    }

    public static ComparisonBinaryExpression greaterEqual(Expression left, Expression right) {
        return new ComparisonBinaryExpression(Operator.GREATER_EQUAL, left, right);
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.left, this.right);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Operator getComparisonType() {
        return this.compOperator;
    }

    public NormalizedPredicate normalize() {
        if (this.normalizedPredicate != null) {
            return this.normalizedPredicate;
        }
        if (this.getLeft() instanceof Constant && this.getRight() instanceof ColumnRef) {
            Operator newOperator;
            Constant left = (Constant)this.getLeft();
            ColumnRef right = (ColumnRef)this.getRight();
            switch (this.getComparisonType()) {
                case EQUAL: {
                    newOperator = Operator.EQUAL;
                    break;
                }
                case LESS_EQUAL: {
                    newOperator = Operator.GREATER_EQUAL;
                    break;
                }
                case LESS_THAN: {
                    newOperator = Operator.GREATER_THAN;
                    break;
                }
                case GREATER_EQUAL: {
                    newOperator = Operator.LESS_EQUAL;
                    break;
                }
                case GREATER_THAN: {
                    newOperator = Operator.LESS_THAN;
                    break;
                }
                case NOT_EQUAL: {
                    newOperator = Operator.NOT_EQUAL;
                    break;
                }
                default: {
                    throw new TiExpressionException(String.format("PredicateNormalizer is not able to process type %s", new Object[]{this.getComparisonType()}));
                }
            }
            ComparisonBinaryExpression newExpression = new ComparisonBinaryExpression(newOperator, right, left);
            this.normalizedPredicate = new NormalizedPredicate(newExpression);
            return this.normalizedPredicate;
        }
        if (this.getRight() instanceof Constant && this.getLeft() instanceof ColumnRef) {
            this.normalizedPredicate = new NormalizedPredicate(this);
            return this.normalizedPredicate;
        }
        return null;
    }

    public String toString() {
        return String.format("[%s %s %s]", new Object[]{this.getLeft(), this.getComparisonType(), this.getRight()});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComparisonBinaryExpression)) {
            return false;
        }
        ComparisonBinaryExpression that = (ComparisonBinaryExpression)other;
        return this.compOperator == that.compOperator && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.compOperator, this.left, this.right});
    }

    public static class NormalizedPredicate {
        private final ComparisonBinaryExpression pred;
        private TypedKey key;

        NormalizedPredicate(ComparisonBinaryExpression pred) {
            Preconditions.checkArgument(pred.getLeft() instanceof ColumnRef);
            Preconditions.checkArgument(pred.getRight() instanceof Constant);
            this.pred = pred;
        }

        public ColumnRef getColumnRef() {
            return (ColumnRef)this.pred.getLeft();
        }

        public Constant getValue() {
            return (Constant)this.pred.getRight();
        }

        public Operator getType() {
            return this.pred.getComparisonType();
        }

        TypedKey getTypedLiteral() {
            return this.getTypedLiteral(-1);
        }

        public TypedKey getTypedLiteral(int prefixLength) {
            if (this.key == null) {
                DataType colRefType = this.getColumnRef().getDataType();
                this.key = TypedKey.toTypedKey(this.getValue().getValue(), colRefType, prefixLength);
            }
            return this.key;
        }
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL;

    }
}

