/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.exception.CodecException;
import com.pingcap.tikv.key.Handle;
import java.util.Arrays;

public class IntHandle
implements Handle {
    private final long handle;
    private final int infFlag;

    public IntHandle(long handle) {
        this.handle = handle;
        this.infFlag = 0;
    }

    private IntHandle(long handle, int infFlag) {
        this.handle = handle;
        this.infFlag = infFlag;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public long intValue() {
        return this.handle;
    }

    @Override
    public Handle next() {
        if (this.handle != Long.MAX_VALUE) {
            return new IntHandle(this.handle + 1L);
        }
        return new IntHandle(this.handle, 1);
    }

    public boolean equals(Object other) {
        if (other instanceof IntHandle) {
            return ((IntHandle)other).intValue() == this.handle;
        }
        return false;
    }

    @Override
    public int compare(Handle h) {
        long hVal;
        if (!h.isInt()) {
            throw new RuntimeException("IntHandle compares to CommonHandle");
        }
        if (this.infFlag != ((IntHandle)h).infFlag) {
            return this.infFlag - ((IntHandle)h).infFlag;
        }
        long val = this.intValue();
        if (val > (hVal = h.intValue())) {
            return 1;
        }
        if (val < hVal) {
            return -1;
        }
        return 0;
    }

    @Override
    public byte[] encoded() {
        CodecDataOutput cdo = new CodecDataOutput();
        Codec.IntegerCodec.writeLong(cdo, this.handle);
        byte[] encoded = cdo.toBytes();
        if (this.infFlag == 1) {
            return Arrays.copyOf(encoded, encoded.length + 1);
        }
        return encoded;
    }

    @Override
    public int len() {
        if (this.infFlag == 1) {
            return 9;
        }
        return 8;
    }

    @Override
    public int numCols() {
        throw new CodecException("not supported in IntHandle");
    }

    @Override
    public byte[] encodedCol(int idx) {
        throw new CodecException("not supported in IntHandle");
    }

    @Override
    public Object[] data() {
        return new Object[]{this.handle};
    }

    public String toString() {
        if (this.infFlag == -1) {
            return "-inf";
        }
        if (this.infFlag == 1) {
            return "+inf";
        }
        return String.valueOf(this.handle);
    }
}

