/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.predicates;

import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.visitor.DefaultVisitor;
import com.pingcap.tikv.expression.visitor.PseudoCostCalculator;
import com.pingcap.tikv.predicates.ScanSpec;
import java.util.Optional;

public class SelectivityCalculator
extends DefaultVisitor<Double, Void> {
    public static double calcPseudoSelectivity(ScanSpec spec) {
        Optional<Expression> rangePred = spec.getRangePredicate();
        double cost = 100.0;
        if (spec.getPointPredicates() != null) {
            for (Expression expr : spec.getPointPredicates()) {
                cost *= PseudoCostCalculator.calculateCost(expr);
            }
        }
        if (rangePred.isPresent()) {
            cost *= PseudoCostCalculator.calculateCost(rangePred.get());
        }
        return cost;
    }

    @Override
    protected Double process(Expression node, Void context) {
        return 1.0;
    }
}

