/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.region;

import com.pingcap.com.google.common.collect.RangeMap;
import com.pingcap.com.google.common.collect.TreeRangeMap;
import com.pingcap.tikv.ReadOnlyPDClient;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.event.CacheInvalidateEvent;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.KeyRangeUtils;
import com.pingcap.tikv.util.LogDesensitization;
import com.pingcap.tikv.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class RegionManager {
    private static final Logger logger = LoggerFactory.getLogger(RegionManager.class);
    private final RegionCache cache;
    private final Function<CacheInvalidateEvent, Void> cacheInvalidateCallback;

    public RegionManager(ReadOnlyPDClient pdClient, Function<CacheInvalidateEvent, Void> cacheInvalidateCallback) {
        this.cache = new RegionCache(pdClient);
        this.cacheInvalidateCallback = cacheInvalidateCallback;
    }

    public Function<CacheInvalidateEvent, Void> getCacheInvalidateCallback() {
        return this.cacheInvalidateCallback;
    }

    public TiRegion getRegionByKey(ByteString key) {
        return this.getRegionByKey(key, ConcreteBackOffer.newGetBackOff());
    }

    public TiRegion getRegionByKey(ByteString key, BackOffer backOffer) {
        return this.cache.getRegionByKey(key, backOffer);
    }

    @Deprecated
    public TiRegion getRegionById(long regionId) {
        return this.cache.getRegionById(ConcreteBackOffer.newGetBackOff(), regionId);
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key, BackOffer backOffer) {
        return this.getRegionStorePairByKey(key, TiStoreType.TiKV, backOffer);
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key) {
        return this.getRegionStorePairByKey(key, TiStoreType.TiKV);
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key, TiStoreType storeType) {
        return this.getRegionStorePairByKey(key, storeType, ConcreteBackOffer.newGetBackOff());
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key, TiStoreType storeType, BackOffer backOffer) {
        TiRegion region = this.cache.getRegionByKey(key, backOffer);
        if (region == null) {
            throw new TiClientInternalException("Region not exist for key:" + LogDesensitization.hide(KeyUtils.formatBytesUTF8(key)));
        }
        if (!region.isValid()) {
            throw new TiClientInternalException("Region invalid: " + region.toString());
        }
        Metapb.Store store = null;
        if (storeType == TiStoreType.TiKV) {
            Metapb.Peer leader = region.getLeader();
            store = this.cache.getStoreById(leader.getStoreId(), backOffer);
        } else {
            block0: for (Metapb.Peer peer : region.getLearnerList()) {
                Metapb.Store s = this.getStoreById(peer.getStoreId(), backOffer);
                for (Metapb.StoreLabel label : s.getLabelsList()) {
                    if (!label.getKey().equals(storeType.getLabelKey()) || !label.getValue().equals(storeType.getLabelValue())) continue;
                    store = s;
                    break block0;
                }
            }
            if (store == null) {
                this.cache.invalidateRegion(region.getId());
            }
        }
        if (store == null) {
            throw new TiClientInternalException("Cannot find valid store on " + (Object)((Object)storeType) + " for region " + region.toString());
        }
        return Pair.create(region, store);
    }

    public Metapb.Store getStoreById(long id) {
        return this.getStoreById(id, ConcreteBackOffer.newGetBackOff());
    }

    public Metapb.Store getStoreById(long id, BackOffer backOffer) {
        return this.cache.getStoreById(id, backOffer);
    }

    public void onRegionStale(long regionId) {
        this.cache.invalidateRegion(regionId);
    }

    public boolean updateLeader(long regionId, long storeId) {
        TiRegion r = (TiRegion)this.cache.regionCache.get(regionId);
        if (r != null && !r.switchPeer(storeId)) {
            logger.warn("Cannot find peer when updating leader (" + regionId + "," + storeId + ")");
            this.cache.invalidateRegion(regionId);
            return false;
        }
        return true;
    }

    public void onRequestFail(TiRegion region) {
        this.onRequestFail(region.getId(), region.getLeader().getStoreId());
    }

    public void onRequestFail(long regionId, long storeId) {
        this.cache.invalidateRegion(regionId);
        this.cache.invalidateAllRegionForStore(storeId);
    }

    public void invalidateStore(long storeId) {
        this.cache.invalidateStore(storeId);
    }

    public void invalidateRegion(long regionId) {
        this.cache.invalidateRegion(regionId);
    }

    public static class RegionCache {
        private final Map<Long, TiRegion> regionCache = new HashMap<Long, TiRegion>();
        private final Map<Long, Metapb.Store> storeCache = new HashMap<Long, Metapb.Store>();
        private final RangeMap<Key, Long> keyToRegionIdCache = TreeRangeMap.create();
        private final ReadOnlyPDClient pdClient;

        public RegionCache(ReadOnlyPDClient pdClient) {
            this.pdClient = pdClient;
        }

        public synchronized TiRegion getRegionByKey(ByteString key, BackOffer backOffer) {
            Long regionId = this.keyToRegionIdCache.get(Key.toRawKey(key));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("getRegionByKey key[%s] -> ID[%s]", LogDesensitization.hide(KeyUtils.formatBytesUTF8(key)), regionId));
            }
            if (regionId == null) {
                logger.debug("Key not find in keyToRegionIdCache:" + LogDesensitization.hide(KeyUtils.formatBytesUTF8(key)));
                TiRegion region = this.pdClient.getRegionByKey(backOffer, key);
                if (!this.putRegion(region)) {
                    throw new TiClientInternalException("Invalid Region: " + region.toString());
                }
                return region;
            }
            TiRegion region = this.regionCache.get(regionId);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("getRegionByKey ID[%s] -> Region[%s]", regionId, region));
            }
            return region;
        }

        private synchronized boolean putRegion(TiRegion region) {
            if (logger.isDebugEnabled()) {
                logger.debug("putRegion: " + region);
            }
            this.regionCache.put(region.getId(), region);
            this.keyToRegionIdCache.put(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()), region.getId());
            return true;
        }

        private synchronized TiRegion getRegionById(BackOffer backOffer, long regionId) {
            TiRegion region = this.regionCache.get(regionId);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("getRegionByKey ID[%s] -> Region[%s]", regionId, region));
            }
            if (region == null && !this.putRegion(region = this.pdClient.getRegionByID(backOffer, regionId))) {
                throw new TiClientInternalException("Invalid Region: " + region.toString());
            }
            return region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void invalidateRegion(long regionId) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("invalidateRegion ID[%s]", regionId));
                }
                TiRegion region = this.regionCache.get(regionId);
                this.keyToRegionIdCache.remove(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()));
            }
            catch (Exception exception) {
            }
            finally {
                this.regionCache.remove(regionId);
            }
        }

        public synchronized void invalidateAllRegionForStore(long storeId) {
            ArrayList<TiRegion> regionToRemove = new ArrayList<TiRegion>();
            for (TiRegion r : this.regionCache.values()) {
                if (r.getLeader().getStoreId() != storeId) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("invalidateAllRegionForStore Region[%s]", r));
                }
                regionToRemove.add(r);
            }
            for (TiRegion r : regionToRemove) {
                this.regionCache.remove(r.getId());
                this.keyToRegionIdCache.remove(KeyRangeUtils.makeRange(r.getStartKey(), r.getEndKey()));
            }
        }

        public synchronized void invalidateStore(long storeId) {
            this.storeCache.remove(storeId);
        }

        public synchronized Metapb.Store getStoreById(long id, BackOffer backOffer) {
            try {
                Metapb.Store store = this.storeCache.get(id);
                if (store == null) {
                    store = this.pdClient.getStore(backOffer, id);
                }
                if (store.getState().equals(Metapb.StoreState.Tombstone)) {
                    return null;
                }
                this.storeCache.put(id, store);
                return store;
            }
            catch (Exception e) {
                throw new GrpcException(e);
            }
        }
    }
}

