/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.region;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.util.FastByteComparisons;
import com.pingcap.tikv.util.KeyRangeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class TiRegion
implements Serializable {
    private final Metapb.Region meta;
    private final Kvrpcpb.IsolationLevel isolationLevel;
    private final Kvrpcpb.CommandPri commandPri;
    private Metapb.Peer peer;

    public TiRegion(Metapb.Region meta, Metapb.Peer peer, Kvrpcpb.IsolationLevel isolationLevel, Kvrpcpb.CommandPri commandPri) {
        Objects.requireNonNull(meta, "meta is null");
        this.meta = this.decodeRegion(meta);
        if (peer == null || peer.getId() == 0L) {
            if (meta.getPeersCount() == 0) {
                throw new TiClientInternalException("Empty peer list for region " + meta.getId());
            }
            this.peer = meta.getPeers(0);
        } else {
            this.peer = peer;
        }
        this.isolationLevel = isolationLevel;
        this.commandPri = commandPri;
    }

    private Metapb.Region decodeRegion(Metapb.Region region) {
        Metapb.Region.Builder builder = Metapb.Region.newBuilder().setId(region.getId()).setRegionEpoch(region.getRegionEpoch()).addAllPeers(region.getPeersList());
        if (region.getStartKey().isEmpty()) {
            builder.setStartKey(region.getStartKey());
        } else {
            byte[] decodedStartKey = Codec.BytesCodec.readBytes(new CodecDataInput(region.getStartKey()));
            builder.setStartKey(ByteString.copyFrom(decodedStartKey));
        }
        if (region.getEndKey().isEmpty()) {
            builder.setEndKey(region.getEndKey());
        } else {
            byte[] decodedEndKey = Codec.BytesCodec.readBytes(new CodecDataInput(region.getEndKey()));
            builder.setEndKey(ByteString.copyFrom(decodedEndKey));
        }
        return builder.build();
    }

    public Metapb.Peer getLeader() {
        return this.peer;
    }

    public List<Metapb.Peer> getLearnerList() {
        ArrayList<Metapb.Peer> peers = new ArrayList<Metapb.Peer>();
        for (Metapb.Peer peer : this.getMeta().getPeersList()) {
            if (!peer.getRole().equals(Metapb.PeerRole.Learner)) continue;
            peers.add(peer);
        }
        return peers;
    }

    public long getId() {
        return this.meta.getId();
    }

    public ByteString getStartKey() {
        return this.meta.getStartKey();
    }

    public boolean contains(Key key) {
        return KeyRangeUtils.makeRange(this.getStartKey(), this.getEndKey()).contains(key);
    }

    public ByteString getEndKey() {
        return this.meta.getEndKey();
    }

    public Key getRowEndKey() {
        return Key.toRawKey(this.getEndKey());
    }

    public Kvrpcpb.Context getContext() {
        return this.getContext(Collections.emptySet());
    }

    public Kvrpcpb.Context getContext(Set<Long> resolvedLocks) {
        Kvrpcpb.Context.Builder builder = Kvrpcpb.Context.newBuilder();
        builder.setIsolationLevel(this.isolationLevel);
        builder.setPriority(this.commandPri);
        builder.setRegionId(this.meta.getId()).setPeer(this.peer).setRegionEpoch(this.meta.getRegionEpoch());
        builder.addAllResolvedLocks(resolvedLocks);
        return builder.build();
    }

    public RegionVerID getVerID() {
        return new RegionVerID(this.meta.getId(), this.meta.getRegionEpoch().getConfVer(), this.meta.getRegionEpoch().getVersion());
    }

    boolean switchPeer(long leaderStoreID) {
        List<Metapb.Peer> peers = this.meta.getPeersList();
        for (Metapb.Peer p : peers) {
            if (p.getStoreId() != leaderStoreID) continue;
            this.peer = p;
            return true;
        }
        return false;
    }

    public boolean isMoreThan(ByteString key) {
        return FastByteComparisons.compareTo(this.meta.getStartKey().toByteArray(), 0, this.meta.getStartKey().size(), key.toByteArray(), 0, key.size()) > 0;
    }

    public boolean isLessThan(ByteString key) {
        return FastByteComparisons.compareTo(this.meta.getEndKey().toByteArray(), 0, this.meta.getEndKey().size(), key.toByteArray(), 0, key.size()) <= 0;
    }

    public boolean contains(ByteString key) {
        return !this.isMoreThan(key) && !this.isLessThan(key);
    }

    public boolean isValid() {
        return this.peer != null && this.meta != null;
    }

    public Metapb.RegionEpoch getRegionEpoch() {
        return this.meta.getRegionEpoch();
    }

    public Metapb.Region getMeta() {
        return this.meta;
    }

    public boolean equals(Object another) {
        if (!(another instanceof TiRegion)) {
            return false;
        }
        TiRegion anotherRegion = (TiRegion)another;
        return anotherRegion.meta.equals(this.meta) && anotherRegion.peer.equals(this.peer) && anotherRegion.commandPri.equals(this.commandPri) && anotherRegion.isolationLevel.equals(this.isolationLevel);
    }

    public int hashCode() {
        return Objects.hash(this.meta, this.peer, this.isolationLevel, this.commandPri);
    }

    public String toString() {
        return String.format("{Region[%d] ConfVer[%d] Version[%d] Store[%d] KeyRange[%s]:[%s]}", this.getId(), this.getRegionEpoch().getConfVer(), this.getRegionEpoch().getVersion(), this.getLeader().getStoreId(), KeyUtils.formatBytesUTF8(this.getStartKey()), KeyUtils.formatBytesUTF8(this.getEndKey()));
    }

    public class RegionVerID {
        final long id;
        final long confVer;
        final long ver;

        RegionVerID(long id, long confVer, long ver) {
            this.id = id;
            this.confVer = confVer;
            this.ver = ver;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegionVerID)) {
                return false;
            }
            RegionVerID that = (RegionVerID)other;
            return this.id == that.id && this.confVer == that.confVer && this.ver == that.ver;
        }

        public int hashCode() {
            int hash = Long.hashCode(this.id);
            hash = hash * 31 + Long.hashCode(this.confVer);
            hash = hash * 31 + Long.hashCode(this.ver);
            return hash;
        }
    }
}

