/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.txn;

import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class Lock {
    private static final long DEFAULT_LOCK_TTL = 3000L;
    private final long txnID;
    private final long ttl;
    private final ByteString key;
    private final ByteString primary;
    private final long txnSize;
    private final Kvrpcpb.Op lockType;
    private final boolean useAsyncCommit;
    private final long lockForUpdateTs;
    private final long minCommitTS;

    public Lock(Kvrpcpb.LockInfo l) {
        this.txnID = l.getLockVersion();
        this.key = l.getKey();
        this.primary = l.getPrimaryLock();
        this.ttl = l.getLockTtl() == 0L ? 3000L : l.getLockTtl();
        this.txnSize = l.getTxnSize();
        this.lockType = l.getLockType();
        this.useAsyncCommit = l.getUseAsyncCommit();
        this.lockForUpdateTs = l.getLockForUpdateTs();
        this.minCommitTS = l.getMinCommitTs();
    }

    public long getTxnID() {
        return this.txnID;
    }

    public long getTtl() {
        return this.ttl;
    }

    public ByteString getKey() {
        return this.key;
    }

    public ByteString getPrimary() {
        return this.primary;
    }

    public long getTxnSize() {
        return this.txnSize;
    }

    public Kvrpcpb.Op getLockType() {
        return this.lockType;
    }

    public long getLockForUpdateTs() {
        return this.lockForUpdateTs;
    }

    public boolean isUseAsyncCommit() {
        return this.useAsyncCommit;
    }

    public long getMinCommitTS() {
        return this.minCommitTS;
    }
}

