/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.txn;

import com.pingcap.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pingcap.tikv.PDClient;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.Utils;
import com.pingcap.tikv.exception.KeyException;
import com.pingcap.tikv.exception.RegionException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.exception.TxnNotFoundException;
import com.pingcap.tikv.exception.WriteConflictException;
import com.pingcap.tikv.operation.KVErrorHandler;
import com.pingcap.tikv.region.AbstractRegionStoreClient;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.AbstractLockResolverClient;
import com.pingcap.tikv.txn.AsyncResolveData;
import com.pingcap.tikv.txn.Lock;
import com.pingcap.tikv.txn.ResolveLockResult;
import com.pingcap.tikv.txn.TxnExpireTime;
import com.pingcap.tikv.txn.TxnStatus;
import com.pingcap.tikv.txn.type.GroupKeyResult;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ChannelFactory;
import com.pingcap.tikv.util.Pair;
import com.pingcap.tikv.util.TsoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.TikvGrpc;
import shade.com.google.protobuf.ByteString;

public class LockResolverClientV4
extends AbstractRegionStoreClient
implements AbstractLockResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(LockResolverClientV4.class);
    private final ReadWriteLock readWriteLock;
    private final Map<Long, TxnStatus> resolved = new HashMap<Long, TxnStatus>();
    private final Queue<Long> recentResolved = new LinkedList<Long>();
    private final PDClient pdClient;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;

    public LockResolverClientV4(TiConfiguration conf, TiRegion region, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvStub asyncStub, ChannelFactory channelFactory, RegionManager regionManager, PDClient pdClient, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        super(conf, region, channelFactory, blockingStub, asyncStub, regionManager);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.pdClient = pdClient;
        this.clientBuilder = clientBuilder;
    }

    @Override
    public String getVersion() {
        return "V4";
    }

    @Override
    public ResolveLockResult resolveLocks(BackOffer bo, long callerStartTS, List<Lock> locks, boolean forWrite) {
        TxnExpireTime msBeforeTxnExpired = new TxnExpireTime();
        if (locks.isEmpty()) {
            return new ResolveLockResult(msBeforeTxnExpired.value());
        }
        HashMap<Long, Set> cleanTxns = new HashMap<Long, Set>();
        boolean pushFail = false;
        HashSet<Long> pushed = new HashSet<Long>(locks.size());
        for (Lock l : locks) {
            TxnStatus status = this.getTxnStatusFromLock(bo, l, callerStartTS);
            if (status.getTtl() == 0L) {
                Set cleanRegion = cleanTxns.computeIfAbsent(l.getTxnID(), k -> new HashSet());
                if (status.getPrimaryLock() != null && status.getPrimaryLock().getUseAsyncCommit()) {
                    this.resolveLockAsync(bo, l, status);
                    continue;
                }
                if (l.getLockType() == Kvrpcpb.Op.PessimisticLock) {
                    this.resolvePessimisticLock(bo, l, cleanRegion);
                    continue;
                }
                this.resolveLock(bo, l, status, cleanRegion);
                continue;
            }
            long msBeforeLockExpired = TsoUtils.untilExpired(l.getTxnID(), status.getTtl());
            msBeforeTxnExpired.update(msBeforeLockExpired);
            if (forWrite) {
                if (l.getLockType() == Kvrpcpb.Op.PessimisticLock || l.getTxnID() <= callerStartTS) continue;
                throw new WriteConflictException(callerStartTS, l.getTxnID(), status.getCommitTS(), l.getKey().toByteArray());
            }
            if (status.getAction() != Kvrpcpb.Action.MinCommitTSPushed) {
                pushFail = true;
                continue;
            }
            pushed.add(l.getTxnID());
        }
        if (pushFail) {
            pushed = new HashSet();
        }
        return new ResolveLockResult(msBeforeTxnExpired.value(), pushed);
    }

    private void resolvePessimisticLock(BackOffer bo, Lock lock, Set<TiRegion.RegionVerID> cleanRegion) {
        Kvrpcpb.PessimisticRollbackResponse resp2;
        while (true) {
            this.region = this.regionManager.getRegionByKey(lock.getKey());
            if (cleanRegion.contains(this.region.getVerID())) {
                return;
            }
            long forUpdateTS = lock.getLockForUpdateTs() == 0L ? Long.MAX_VALUE : lock.getLockForUpdateTs();
            Supplier<Kvrpcpb.PessimisticRollbackRequest> factory = () -> Kvrpcpb.PessimisticRollbackRequest.newBuilder().setContext(this.region.getContext()).setStartVersion(lock.getTxnID()).setForUpdateTs(forUpdateTS).addKeys(lock.getKey()).build();
            KVErrorHandler<Kvrpcpb.PessimisticRollbackResponse> handler = new KVErrorHandler<Kvrpcpb.PessimisticRollbackResponse>(this.regionManager, this, this, this.region, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.getErrorsCount() > 0 ? resp.getErrorsList().get(0) : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKVPessimisticRollbackMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKVPessimisticRollbackMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKVPessimisticRollbackMethod failed without a cause"));
                continue;
            }
            if (resp2.hasRegionError()) {
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
                continue;
            }
            if (resp2.getErrorsCount() > 0) break;
        }
        logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getErrorsList().get(0), lock));
        throw new KeyException(resp2.getErrorsList().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TxnStatus getTxnStatusFromLock(BackOffer bo, Lock lock, long callerStartTS) {
        long currentTS = lock.getTtl() == 0L ? Long.MAX_VALUE : this.pdClient.getTimestamp(bo).getVersion();
        boolean rollbackIfNotExist = false;
        while (true) {
            try {
                return this.getTxnStatus(bo, lock.getTxnID(), lock.getPrimary(), callerStartTS, currentTS, rollbackIfNotExist, lock);
            }
            catch (TxnNotFoundException e) {
                logger.warn("getTxnStatus error!", (Throwable)e);
                try {
                    bo.doBackOff(BackOffFunction.BackOffFuncType.BoTxnNotFound, e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (TsoUtils.untilExpired(lock.getTxnID(), lock.getTtl()) <= 0L) {
                    logger.warn(String.format("lock txn not found, lock has expired, CallerStartTs=%d lock str=%s", callerStartTS, lock.toString()));
                    if (lock.getLockType() == Kvrpcpb.Op.PessimisticLock) {
                        return new TxnStatus();
                    }
                    rollbackIfNotExist = true;
                    continue;
                }
                if (lock.getLockType() == Kvrpcpb.Op.PessimisticLock) return new TxnStatus(lock.getTtl());
                continue;
            }
            break;
        }
    }

    private TxnStatus getTxnStatus(BackOffer bo, Long txnID, ByteString primary, Long callerStartTS, Long currentTS, boolean rollbackIfNotExist, Lock lock) {
        Kvrpcpb.CheckTxnStatusResponse resp2;
        TxnStatus status = this.getResolved(txnID);
        if (status != null) {
            return status;
        }
        Supplier<Kvrpcpb.CheckTxnStatusRequest> factory = () -> {
            TiRegion primaryKeyRegion = this.regionManager.getRegionByKey(primary);
            return Kvrpcpb.CheckTxnStatusRequest.newBuilder().setContext(primaryKeyRegion.getContext()).setPrimaryKey(primary).setLockTs(txnID).setCallerStartTs(callerStartTS).setCurrentTs(currentTS).setRollbackIfNotExist(rollbackIfNotExist).build();
        };
        while (true) {
            TiRegion primaryKeyRegion = this.regionManager.getRegionByKey(primary);
            RegionStoreClient primaryKeyRegionStoreClient = this.clientBuilder.build(primary);
            KVErrorHandler<Kvrpcpb.CheckTxnStatusResponse> handler = new KVErrorHandler<Kvrpcpb.CheckTxnStatusResponse>(this.regionManager, primaryKeyRegionStoreClient, primaryKeyRegionStoreClient.lockResolverClient, primaryKeyRegion, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, callerStartTS, false);
            resp2 = primaryKeyRegionStoreClient.callWithRetry(bo, TikvGrpc.getKvCheckTxnStatusMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvCheckTxnStatusMethod failed without a cause");
                this.regionManager.onRequestFail(primaryKeyRegion);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvCheckTxnStatusMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            Kvrpcpb.KeyError keyError = resp2.getError();
            if (keyError.hasTxnNotFound()) {
                throw new TxnNotFoundException();
            }
            logger.error(String.format("unexpected cleanup err: %s, tid: %d", keyError, txnID));
            throw new KeyException(keyError);
        }
        status = new TxnStatus();
        status.setAction(resp2.getAction());
        status.setPrimaryLock(resp2.getLockInfo());
        if (status.getPrimaryLock() != null && status.getPrimaryLock().getUseAsyncCommit()) {
            if (!TsoUtils.isExpired(txnID, resp2.getLockTtl())) {
                status.setTtl(resp2.getLockTtl());
            }
        } else if (resp2.getLockTtl() != 0L) {
            status.setTtl(resp2.getLockTtl());
        } else {
            status.setCommitTS(resp2.getCommitVersion());
            if (status.isCommitted() || lock != null && lock.getLockType() != Kvrpcpb.Op.PessimisticLock) {
                this.saveResolved(txnID, status);
            }
        }
        return status;
    }

    private void resolveLockAsync(BackOffer bo, Lock lock, TxnStatus status) {
        AsyncResolveData resolveData = this.checkAllSecondaries(bo, lock, status);
        status.setCommitTS(resolveData.getCommitTs());
        resolveData.appendKey(lock.getPrimary());
        GroupKeyResult groupResult = Utils.groupKeysByRegion(this.regionManager, resolveData.getKeys(), bo);
        logger.info(String.format("resolve async commit, startTS=%d, commitTS=%d", lock.getTxnID(), status.getCommitTS()));
        ExecutorService executorService = Executors.newFixedThreadPool(this.conf.getKvClientConcurrency(), new ThreadFactoryBuilder().setDaemon(true).build());
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(executorService);
        for (Map.Entry<Pair<TiRegion, Metapb.Store>, List<ByteString>> entry : groupResult.getGroupsResult().entrySet()) {
            TiRegion tiRegion = (TiRegion)entry.getKey().first;
            List<ByteString> keys = entry.getValue();
            completionService.submit(() -> this.resolveRegionLocks(bo, lock, tiRegion, keys, status));
        }
        try {
            for (int i = 0; i < groupResult.getGroupsResult().size(); ++i) {
                completionService.take().get();
            }
        }
        catch (InterruptedException e) {
            logger.info("async commit recovery (sending ResolveLock) finished with errors", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new TiKVException("Current thread interrupted.", e);
        }
        catch (ExecutionException e) {
            logger.info("async commit recovery (sending ResolveLock) finished with errors", (Throwable)e);
            throw new TiKVException("Execution exception met.", e);
        }
        catch (Throwable e) {
            logger.info("async commit recovery (sending ResolveLock) finished with errors", e);
            throw e;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private AsyncResolveData checkAllSecondaries(BackOffer bo, Lock lock, TxnStatus status) {
        AsyncResolveData shared = new AsyncResolveData(status.getPrimaryLock().getMinCommitTs(), new ArrayList<ByteString>(), false);
        GroupKeyResult groupResult = Utils.groupKeysByRegion(this.regionManager, status.getPrimaryLock().getSecondariesList(), bo);
        ExecutorService executorService = Executors.newFixedThreadPool(this.conf.getKvClientConcurrency(), new ThreadFactoryBuilder().setDaemon(true).build());
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(executorService);
        for (Map.Entry<Pair<TiRegion, Metapb.Store>, List<ByteString>> entry : groupResult.getGroupsResult().entrySet()) {
            TiRegion tiRegion = (TiRegion)entry.getKey().first;
            List<ByteString> keys = entry.getValue();
            completionService.submit(() -> this.checkSecondaries(bo, lock.getTxnID(), keys, tiRegion, shared));
        }
        try {
            for (int i = 0; i < groupResult.getGroupsResult().size(); ++i) {
                completionService.take().get();
            }
            AsyncResolveData i = shared;
            return i;
        }
        catch (InterruptedException e) {
            logger.info("async commit recovery (sending CheckSecondaryLocks) finished with errors", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new TiKVException("Current thread interrupted.", e);
        }
        catch (ExecutionException e) {
            logger.info("async commit recovery (sending CheckSecondaryLocks) finished with errors", (Throwable)e);
            throw new TiKVException("Execution exception met.", e);
        }
        catch (Throwable e) {
            logger.info("async commit recovery (sending CheckSecondaryLocks) finished with errors", e);
            throw e;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private boolean checkSecondaries(BackOffer bo, long txnID, List<ByteString> curKeys, TiRegion tiRegion, AsyncResolveData shared) {
        RegionStoreClient regionStoreClient = this.clientBuilder.build(tiRegion);
        Supplier<Kvrpcpb.CheckSecondaryLocksRequest> factory = () -> Kvrpcpb.CheckSecondaryLocksRequest.newBuilder().setContext(tiRegion.getContext()).setStartVersion(txnID).addAllKeys(curKeys).build();
        KVErrorHandler<Kvrpcpb.CheckSecondaryLocksResponse> handler = new KVErrorHandler<Kvrpcpb.CheckSecondaryLocksResponse>(this.regionManager, regionStoreClient, regionStoreClient.lockResolverClient, tiRegion, resp -> null, resp -> null, resolveLockResult -> null, 0L, false);
        Kvrpcpb.CheckSecondaryLocksResponse resp2 = regionStoreClient.callWithRetry(bo, TikvGrpc.getKvCheckSecondaryLocksMethod(), factory, handler);
        if (resp2 == null) {
            logger.error("getKvCheckSecondaryLocksMethod failed without a cause");
            this.regionManager.onRequestFail(tiRegion);
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvCheckSecondaryLocksMethod failed without a cause"));
            logger.debug(String.format("checkSecondaries: region error, regrouping, txnID=%d, regionId=%d", txnID, tiRegion.getId()));
            GroupKeyResult groupResult = Utils.groupKeysByRegion(this.regionManager, curKeys, bo);
            for (Map.Entry<Pair<TiRegion, Metapb.Store>, List<ByteString>> entry : groupResult.getGroupsResult().entrySet()) {
                TiRegion region = (TiRegion)entry.getKey().first;
                List<ByteString> keys = entry.getValue();
                this.checkSecondaries(bo, txnID, keys, region, shared);
            }
        }
        shared.addKeys(resp2.getLocksList(), curKeys.size(), txnID, resp2.getCommitTs());
        return true;
    }

    private boolean resolveRegionLocks(BackOffer bo, Lock lock, TiRegion tiRegion, List<ByteString> keys, TxnStatus status) {
        RegionStoreClient regionStoreClient = this.clientBuilder.build(tiRegion);
        Supplier<Kvrpcpb.ResolveLockRequest> factory = () -> Kvrpcpb.ResolveLockRequest.newBuilder().setContext(tiRegion.getContext()).setStartVersion(lock.getTxnID()).setCommitVersion(status.getCommitTS()).addAllKeys(keys).build();
        KVErrorHandler<Kvrpcpb.ResolveLockResponse> handler = new KVErrorHandler<Kvrpcpb.ResolveLockResponse>(this.regionManager, regionStoreClient, regionStoreClient.lockResolverClient, tiRegion, resp -> null, resp -> null, resolveLockResult -> null, 0L, false);
        Kvrpcpb.ResolveLockResponse resp2 = regionStoreClient.callWithRetry(bo, TikvGrpc.getKvResolveLockMethod(), factory, handler);
        if (resp2 == null || resp2.hasRegionError()) {
            logger.error("getKvResolveLockMethod failed without a cause");
            this.regionManager.onRequestFail(tiRegion);
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvResolveLockMethod failed without a cause"));
            logger.debug(String.format("resolveRegionLocks region error, regrouping lock=%s region=%d", lock, tiRegion.getId()));
            GroupKeyResult groupResult = Utils.groupKeysByRegion(this.regionManager, keys, bo);
            for (Map.Entry<Pair<TiRegion, Metapb.Store>, List<ByteString>> entry : groupResult.getGroupsResult().entrySet()) {
                TiRegion region = (TiRegion)entry.getKey().first;
                this.resolveRegionLocks(bo, lock, region, entry.getValue(), status);
            }
        } else if (resp2.hasError()) {
            logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getError(), lock));
            throw new KeyException(resp2.getError());
        }
        return true;
    }

    private void resolveLock(BackOffer bo, Lock lock, TxnStatus txnStatus, Set<TiRegion.RegionVerID> cleanRegion) {
        Kvrpcpb.ResolveLockResponse resp2;
        boolean cleanWholeRegion = lock.getTxnSize() >= 16L;
        while (true) {
            this.region = this.regionManager.getRegionByKey(lock.getKey());
            if (cleanRegion.contains(this.region.getVerID())) {
                return;
            }
            Kvrpcpb.ResolveLockRequest.Builder builder = Kvrpcpb.ResolveLockRequest.newBuilder().setContext(this.region.getContext()).setStartVersion(lock.getTxnID());
            if (txnStatus.isCommitted()) {
                builder.setCommitVersion(txnStatus.getCommitTS());
            }
            if (lock.getTxnSize() < 16L) {
                builder.addKeys(lock.getKey());
            }
            Supplier<Kvrpcpb.ResolveLockRequest> factory = builder::build;
            KVErrorHandler<Kvrpcpb.ResolveLockResponse> handler = new KVErrorHandler<Kvrpcpb.ResolveLockResponse>(this.regionManager, this, this, this.region, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKvResolveLockMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvResolveLockMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvResolveLockMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getError(), lock));
            throw new KeyException(resp2.getError());
        }
        if (cleanWholeRegion) {
            cleanRegion.add(this.region.getVerID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResolved(long txnID, TxnStatus status) {
        try {
            this.readWriteLock.writeLock().lock();
            if (this.resolved.containsKey(txnID)) {
                return;
            }
            this.resolved.put(txnID, status);
            this.recentResolved.add(txnID);
            if ((long)this.recentResolved.size() > 2048L) {
                Long front = this.recentResolved.remove();
                this.resolved.remove(front);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private TxnStatus getResolved(Long txnID) {
        try {
            this.readWriteLock.readLock().lock();
            TxnStatus txnStatus = this.resolved.get(txnID);
            return txnStatus;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

