/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import shade.io.grpc.ManagedChannel;
import shade.io.grpc.ManagedChannelBuilder;

public class ChannelFactory
implements AutoCloseable {
    private final int maxFrameSize;
    private final Map<String, ManagedChannel> connPool = new ConcurrentHashMap<String, ManagedChannel>();

    public ChannelFactory(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public ManagedChannel getChannel(String addressStr) {
        return this.connPool.computeIfAbsent(addressStr, key -> {
            URI address;
            try {
                address = URI.create("http://" + key);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to form address " + key);
            }
            return ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(address.getHost(), address.getPort()).maxInboundMessageSize(this.maxFrameSize)).usePlaintext()).idleTimeout(60L, TimeUnit.SECONDS)).build();
        });
    }

    @Override
    public void close() {
        this.connPool.forEach((k, v) -> {
            v.shutdownNow();
            try {
                v.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.connPool.clear();
    }
}

