/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreteBackOffer
implements BackOffer {
    private static final Logger logger = LoggerFactory.getLogger(ConcreteBackOffer.class);
    private final int maxSleep;
    private final Map<BackOffFunction.BackOffFuncType, BackOffFunction> backOffFunctionMap;
    private final List<Exception> errors;
    private int totalSleep;

    private ConcreteBackOffer(int maxSleep) {
        Preconditions.checkArgument(maxSleep >= 0, "Max sleep time cannot be less than 0.");
        this.maxSleep = maxSleep;
        this.errors = new ArrayList<Exception>();
        this.backOffFunctionMap = new HashMap<BackOffFunction.BackOffFuncType, BackOffFunction>();
    }

    private ConcreteBackOffer(ConcreteBackOffer source) {
        this.maxSleep = source.maxSleep;
        this.totalSleep = source.totalSleep;
        this.errors = source.errors;
        this.backOffFunctionMap = source.backOffFunctionMap;
    }

    public static ConcreteBackOffer newCustomBackOff(int maxSleep) {
        return new ConcreteBackOffer(maxSleep);
    }

    public static ConcreteBackOffer newScannerNextMaxBackOff() {
        return new ConcreteBackOffer(40000);
    }

    public static ConcreteBackOffer newBatchGetMaxBackOff() {
        return new ConcreteBackOffer(40000);
    }

    public static ConcreteBackOffer newCopNextMaxBackOff() {
        return new ConcreteBackOffer(40000);
    }

    public static ConcreteBackOffer newGetBackOff() {
        return new ConcreteBackOffer(40000);
    }

    public static ConcreteBackOffer newRawKVBackOff() {
        return new ConcreteBackOffer(40000);
    }

    public static ConcreteBackOffer newTsoBackOff() {
        return new ConcreteBackOffer(5000);
    }

    public static ConcreteBackOffer create(BackOffer source) {
        return new ConcreteBackOffer((ConcreteBackOffer)source);
    }

    private BackOffFunction createBackOffFunc(BackOffFunction.BackOffFuncType funcType) {
        BackOffFunction backOffFunction = null;
        switch (funcType) {
            case BoUpdateLeader: {
                backOffFunction = BackOffFunction.create(1, 10, BackOffer.BackOffStrategy.NoJitter);
                break;
            }
            case BoTxnLockFast: {
                backOffFunction = BackOffFunction.create(100, 3000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoServerBusy: {
                backOffFunction = BackOffFunction.create(2000, 10000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoRegionMiss: {
                backOffFunction = BackOffFunction.create(100, 500, BackOffer.BackOffStrategy.NoJitter);
                break;
            }
            case BoTxnLock: {
                backOffFunction = BackOffFunction.create(200, 3000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoPDRPC: {
                backOffFunction = BackOffFunction.create(500, 3000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoTiKVRPC: {
                backOffFunction = BackOffFunction.create(100, 2000, BackOffer.BackOffStrategy.EqualJitter);
                break;
            }
            case BoTxnNotFound: {
                backOffFunction = BackOffFunction.create(2, 500, BackOffer.BackOffStrategy.NoJitter);
            }
        }
        return backOffFunction;
    }

    @Override
    public void doBackOff(BackOffFunction.BackOffFuncType funcType, Exception err) {
        this.doBackOffWithMaxSleep(funcType, -1L, err);
    }

    @Override
    public void doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType funcType, long maxSleepMs, Exception err) {
        BackOffFunction backOffFunction = this.backOffFunctionMap.computeIfAbsent(funcType, this::createBackOffFunc);
        this.totalSleep = (int)((long)this.totalSleep + backOffFunction.doBackOff(maxSleepMs));
        logger.debug(String.format("%s, retry later(totalSleep %dms, maxSleep %dms)", err.getMessage(), this.totalSleep, this.maxSleep));
        this.errors.add(err);
        if (this.maxSleep > 0 && this.totalSleep >= this.maxSleep) {
            StringBuilder errMsg = new StringBuilder(String.format("BackOffer.maxSleep %dms is exceeded, errors:", this.maxSleep));
            for (int i = 0; i < this.errors.size(); ++i) {
                Exception curErr = this.errors.get(i);
                if (!logger.isDebugEnabled() && i < this.errors.size() - 3) continue;
                errMsg.append("\n").append(i).append(".").append(curErr.toString());
            }
            logger.warn(errMsg.toString());
            throw new GrpcException("retry is exhausted.", err);
        }
    }
}

