/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.com.google.common.collect;

import com.pingcap.com.google.common.annotations.GwtCompatible;
import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.com.google.common.collect.CollectPreconditions;
import com.pingcap.com.google.common.collect.Hashing;
import com.pingcap.com.google.common.collect.ImmutableCollection;
import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.com.google.common.collect.ImmutableMap;
import com.pingcap.com.google.common.collect.ImmutableSet;
import com.pingcap.com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private static final byte ABSENT = -1;
    private static final int BYTE_MAX_SIZE = 128;
    private static final int SHORT_MAX_SIZE = 32768;
    private static final int BYTE_MASK = 255;
    private static final int SHORT_MASK = 65535;
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap<Object, Object>(null, new Object[0], 0);
    private final transient Object hashTable;
    @VisibleForTesting
    final transient Object[] alternatingKeysAndValues;
    private final transient int size;
    private static final long serialVersionUID = 0L;

    static <K, V> RegularImmutableMap<K, V> create(int n, Object[] alternatingKeysAndValues) {
        if (n == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(alternatingKeysAndValues[0], alternatingKeysAndValues[1]);
            return new RegularImmutableMap<K, V>(null, alternatingKeysAndValues, 1);
        }
        Preconditions.checkPositionIndex(n, alternatingKeysAndValues.length >> 1);
        int tableSize = ImmutableSet.chooseTableSize(n);
        Object hashTable = RegularImmutableMap.createHashTable(alternatingKeysAndValues, n, tableSize, 0);
        return new RegularImmutableMap<K, V>(hashTable, alternatingKeysAndValues, n);
    }

    static Object createHashTable(Object[] alternatingKeysAndValues, int n, int tableSize, int keyOffset) {
        if (n == 1) {
            CollectPreconditions.checkEntryNotNull(alternatingKeysAndValues[keyOffset], alternatingKeysAndValues[keyOffset ^ 1]);
            return null;
        }
        int mask = tableSize - 1;
        if (tableSize <= 128) {
            byte[] hashTable = new byte[tableSize];
            Arrays.fill(hashTable, (byte)-1);
            for (int i = 0; i < n; ++i) {
                int keyIndex = 2 * i + keyOffset;
                Object key = alternatingKeysAndValues[keyIndex];
                Object value = alternatingKeysAndValues[keyIndex ^ 1];
                CollectPreconditions.checkEntryNotNull(key, value);
                int h = Hashing.smear(key.hashCode());
                while (true) {
                    int previousKeyIndex;
                    if ((previousKeyIndex = hashTable[h &= mask] & 0xFF) == 255) break;
                    if (alternatingKeysAndValues[previousKeyIndex].equals(key)) {
                        throw RegularImmutableMap.duplicateKeyException(key, value, alternatingKeysAndValues, previousKeyIndex);
                    }
                    ++h;
                }
                hashTable[h] = (byte)keyIndex;
            }
            return hashTable;
        }
        if (tableSize <= 32768) {
            short[] hashTable = new short[tableSize];
            Arrays.fill(hashTable, (short)-1);
            for (int i = 0; i < n; ++i) {
                int keyIndex = 2 * i + keyOffset;
                Object key = alternatingKeysAndValues[keyIndex];
                Object value = alternatingKeysAndValues[keyIndex ^ 1];
                CollectPreconditions.checkEntryNotNull(key, value);
                int h = Hashing.smear(key.hashCode());
                while (true) {
                    int previousKeyIndex;
                    if ((previousKeyIndex = hashTable[h &= mask] & 0xFFFF) == 65535) break;
                    if (alternatingKeysAndValues[previousKeyIndex].equals(key)) {
                        throw RegularImmutableMap.duplicateKeyException(key, value, alternatingKeysAndValues, previousKeyIndex);
                    }
                    ++h;
                }
                hashTable[h] = (short)keyIndex;
            }
            return hashTable;
        }
        int[] hashTable = new int[tableSize];
        Arrays.fill(hashTable, -1);
        for (int i = 0; i < n; ++i) {
            int keyIndex = 2 * i + keyOffset;
            Object key = alternatingKeysAndValues[keyIndex];
            Object value = alternatingKeysAndValues[keyIndex ^ 1];
            CollectPreconditions.checkEntryNotNull(key, value);
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int previousKeyIndex;
                if ((previousKeyIndex = hashTable[h &= mask]) == -1) break;
                if (alternatingKeysAndValues[previousKeyIndex].equals(key)) {
                    throw RegularImmutableMap.duplicateKeyException(key, value, alternatingKeysAndValues, previousKeyIndex);
                }
                ++h;
            }
            hashTable[h] = keyIndex;
        }
        return hashTable;
    }

    private static IllegalArgumentException duplicateKeyException(Object key, Object value, Object[] alternatingKeysAndValues, int previousKeyIndex) {
        return new IllegalArgumentException("Multiple entries with same key: " + key + "=" + value + " and " + alternatingKeysAndValues[previousKeyIndex] + "=" + alternatingKeysAndValues[previousKeyIndex ^ 1]);
    }

    private RegularImmutableMap(Object hashTable, Object[] alternatingKeysAndValues, int size) {
        this.hashTable = hashTable;
        this.alternatingKeysAndValues = alternatingKeysAndValues;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NullableDecl
    public V get(@NullableDecl Object key) {
        return (V)RegularImmutableMap.get(this.hashTable, this.alternatingKeysAndValues, this.size, 0, key);
    }

    static Object get(@NullableDecl Object hashTableObject, @NullableDecl Object[] alternatingKeysAndValues, int size, int keyOffset, @NullableDecl Object key) {
        if (key == null) {
            return null;
        }
        if (size == 1) {
            return alternatingKeysAndValues[keyOffset].equals(key) ? alternatingKeysAndValues[keyOffset ^ 1] : null;
        }
        if (hashTableObject == null) {
            return null;
        }
        if (hashTableObject instanceof byte[]) {
            byte[] hashTable = (byte[])hashTableObject;
            int mask = hashTable.length - 1;
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int keyIndex;
                if ((keyIndex = hashTable[h &= mask] & 0xFF) == 255) {
                    return null;
                }
                if (alternatingKeysAndValues[keyIndex].equals(key)) {
                    return alternatingKeysAndValues[keyIndex ^ 1];
                }
                ++h;
            }
        }
        if (hashTableObject instanceof short[]) {
            short[] hashTable = (short[])hashTableObject;
            int mask = hashTable.length - 1;
            int h = Hashing.smear(key.hashCode());
            while (true) {
                int keyIndex;
                if ((keyIndex = hashTable[h &= mask] & 0xFFFF) == 65535) {
                    return null;
                }
                if (alternatingKeysAndValues[keyIndex].equals(key)) {
                    return alternatingKeysAndValues[keyIndex ^ 1];
                }
                ++h;
            }
        }
        int[] hashTable = (int[])hashTableObject;
        int mask = hashTable.length - 1;
        int h = Hashing.smear(key.hashCode());
        int keyIndex;
        while ((keyIndex = hashTable[h &= mask]) != -1) {
            if (alternatingKeysAndValues[keyIndex].equals(key)) {
                return alternatingKeysAndValues[keyIndex ^ 1];
            }
            ++h;
        }
        return null;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, this.alternatingKeysAndValues, 0, this.size);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        KeysOrValuesAsList keyList = new KeysOrValuesAsList(this.alternatingKeysAndValues, 0, this.size);
        return new KeySet<Object>(this, keyList);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new KeysOrValuesAsList(this.alternatingKeysAndValues, 1, this.size);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    static final class KeySet<K>
    extends ImmutableSet<K> {
        private final transient ImmutableMap<K, ?> map;
        private final transient ImmutableList<K> list;

        KeySet(ImmutableMap<K, ?> map, ImmutableList<K> list) {
            this.map = map;
            this.list = list;
        }

        @Override
        public UnmodifiableIterator<K> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        public ImmutableList<K> asList() {
            return this.list;
        }

        @Override
        public boolean contains(@NullableDecl Object object) {
            return this.map.get(object) != null;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    static final class KeysOrValuesAsList
    extends ImmutableList<Object> {
        private final transient Object[] alternatingKeysAndValues;
        private final transient int offset;
        private final transient int size;

        KeysOrValuesAsList(Object[] alternatingKeysAndValues, int offset, int size) {
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.offset = offset;
            this.size = size;
        }

        @Override
        public Object get(int index) {
            Preconditions.checkElementIndex(index, this.size);
            return this.alternatingKeysAndValues[2 * index + this.offset];
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableMap<K, V> map;
        private final transient Object[] alternatingKeysAndValues;
        private final transient int keyOffset;
        private final transient int size;

        EntrySet(ImmutableMap<K, V> map, Object[] alternatingKeysAndValues, int keyOffset, int size) {
            this.map = map;
            this.alternatingKeysAndValues = alternatingKeysAndValues;
            this.keyOffset = keyOffset;
            this.size = size;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        int copyIntoArray(Object[] dst, int offset) {
            return this.asList().copyIntoArray(dst, offset);
        }

        @Override
        ImmutableList<Map.Entry<K, V>> createAsList() {
            return new ImmutableList<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> get(int index) {
                    Preconditions.checkElementIndex(index, EntrySet.this.size);
                    Object key = EntrySet.this.alternatingKeysAndValues[2 * index + EntrySet.this.keyOffset];
                    Object value = EntrySet.this.alternatingKeysAndValues[2 * index + (EntrySet.this.keyOffset ^ 1)];
                    return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
                }

                @Override
                public int size() {
                    return EntrySet.this.size;
                }

                @Override
                public boolean isPartialView() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return v != null && v.equals(this.map.get(k));
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

