/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ExtendedDateTime {
    private final DateTime dateTime;
    private final int microsOfMillis;
    private static final DateTimeZone LOCAL_TIME_ZOME = DateTimeZone.getDefault();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss.S").withZone(LOCAL_TIME_ZOME);

    public ExtendedDateTime(DateTime dateTime, int microsOfMillis) {
        this.dateTime = dateTime;
        this.microsOfMillis = microsOfMillis;
    }

    public ExtendedDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
        this.microsOfMillis = 0;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public int getMicrosOfSeconds() {
        return this.dateTime.getMillisOfSecond() * 1000 + this.microsOfMillis;
    }

    public int getMicrosOfMillis() {
        return this.microsOfMillis;
    }

    public Timestamp toTimeStamp() {
        Timestamp timestamp = Timestamp.valueOf(this.dateTime.toString(DATE_TIME_FORMATTER));
        timestamp.setNanos(this.dateTime.getMillisOfSecond() * 1000000 + this.microsOfMillis * 1000);
        return timestamp;
    }
}

