/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.Preconditions;
import com.pingcap.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pingcap.tikv.AbstractGRPCClient;
import com.pingcap.tikv.ReadOnlyPDClient;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.operation.NoopHandler;
import com.pingcap.tikv.operation.PDErrorHandler;
import com.pingcap.tikv.pd.PDError;
import com.pingcap.tikv.pd.PDUtils;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ChannelFactory;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.FutureObserver;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.PDGrpc;
import org.tikv.kvproto.Pdpb;
import shade.com.google.protobuf.ByteString;
import shade.io.grpc.ManagedChannel;

public class PDClient
extends AbstractGRPCClient<PDGrpc.PDBlockingStub, PDGrpc.PDStub>
implements ReadOnlyPDClient {
    private static final String TIFLASH_TABLE_SYNC_PROGRESS_PATH = "/tiflash/table/sync";
    private final Logger logger = LoggerFactory.getLogger(PDClient.class);
    private Pdpb.RequestHeader header;
    private Pdpb.TsoRequest tsoReq;
    private volatile LeaderWrapper leaderWrapper;
    private ScheduledExecutorService service;
    private ScheduledExecutorService tiflashReplicaService;
    private List<URI> pdAddrs;
    private Client etcdClient;
    private ConcurrentMap<Long, Double> tiflashReplicaMap;

    private PDClient(TiConfiguration conf, ChannelFactory channelFactory) {
        super(conf, channelFactory);
        this.initCluster();
        this.blockingStub = this.getBlockingStub();
        this.asyncStub = this.getAsyncStub();
    }

    public static ReadOnlyPDClient create(TiConfiguration conf, ChannelFactory channelFactory) {
        return PDClient.createRaw(conf, channelFactory);
    }

    static PDClient createRaw(TiConfiguration conf, ChannelFactory channelFactory) {
        return new PDClient(conf, channelFactory);
    }

    @Override
    public TiTimestamp getTimestamp(BackOffer backOffer) {
        Supplier<Pdpb.TsoRequest> request = () -> this.tsoReq;
        PDErrorHandler<Pdpb.TsoResponse> handler = new PDErrorHandler<Pdpb.TsoResponse>(r -> r.getHeader().hasError() ? PDError.buildFromPdpbError(r.getHeader().getError()) : null, this);
        Pdpb.TsoResponse resp = this.callWithRetry(backOffer, PDGrpc.getTsoMethod(), request, handler);
        Pdpb.Timestamp timestamp = resp.getTimestamp();
        return new TiTimestamp(timestamp.getPhysical(), timestamp.getLogical());
    }

    void scatterRegion(TiRegion region, BackOffer backOffer) {
        Supplier<Pdpb.ScatterRegionRequest> request = () -> Pdpb.ScatterRegionRequest.newBuilder().setHeader(this.header).setRegionId(region.getId()).build();
        PDErrorHandler<Pdpb.ScatterRegionResponse> handler = new PDErrorHandler<Pdpb.ScatterRegionResponse>(r -> r.getHeader().hasError() ? PDError.buildFromPdpbError(r.getHeader().getError()) : null, this);
        Pdpb.ScatterRegionResponse resp = this.callWithRetry(backOffer, PDGrpc.getScatterRegionMethod(), request, handler);
        if (resp.hasHeader() && resp.getHeader().hasError()) {
            throw new TiClientInternalException(String.format("failed to scatter region because %s", resp.getHeader().getError()));
        }
    }

    void waitScatterRegionFinish(TiRegion region, BackOffer backOffer) {
        while (true) {
            Pdpb.GetOperatorResponse resp;
            if ((resp = this.getOperator(region.getId())) == null) {
                continue;
            }
            if (this.isScatterRegionFinish(resp)) {
                this.logger.info(String.format("wait scatter region on %d is finished", region.getId()));
                return;
            }
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException("waiting scatter region"));
            this.logger.info(String.format("wait scatter region %d at key %s is %s", region.getId(), KeyUtils.formatBytes(resp.getDesc().toByteArray()), resp.getStatus().toString()));
        }
    }

    private Pdpb.GetOperatorResponse getOperator(long regionId) {
        Supplier<Pdpb.GetOperatorRequest> request = () -> Pdpb.GetOperatorRequest.newBuilder().setHeader(this.header).setRegionId(regionId).build();
        return this.callWithRetry(ConcreteBackOffer.newCustomBackOff(0), PDGrpc.getGetOperatorMethod(), request, new NoopHandler());
    }

    private boolean isScatterRegionFinish(Pdpb.GetOperatorResponse resp) {
        Pdpb.Error error;
        Pdpb.ResponseHeader header;
        boolean finished;
        boolean bl = finished = !resp.getDesc().equals(ByteString.copyFromUtf8("scatter-region")) || resp.getStatus() != Pdpb.OperatorStatus.RUNNING;
        if (resp.hasHeader() && (header = resp.getHeader()).hasError() && (error = header.getError()).getType() == Pdpb.ErrorType.REGION_NOT_FOUND) {
            finished = true;
        }
        return finished;
    }

    @Override
    public TiRegion getRegionByKey(BackOffer backOffer, ByteString key) {
        CodecDataOutput cdo = new CodecDataOutput();
        Codec.BytesCodec.writeBytes(cdo, key.toByteArray());
        ByteString encodedKey = cdo.toByteString();
        Supplier<Pdpb.GetRegionRequest> request = () -> Pdpb.GetRegionRequest.newBuilder().setHeader(this.header).setRegionKey(encodedKey).build();
        PDErrorHandler<Pdpb.GetRegionResponse> handler = new PDErrorHandler<Pdpb.GetRegionResponse>(PDErrorHandler.getRegionResponseErrorExtractor, this);
        Pdpb.GetRegionResponse resp = this.callWithRetry(backOffer, PDGrpc.getGetRegionMethod(), request, handler);
        return new TiRegion(resp.getRegion(), resp.getLeader(), this.conf.getIsolationLevel(), this.conf.getCommandPriority());
    }

    @Override
    public Future<TiRegion> getRegionByKeyAsync(BackOffer backOffer, ByteString key) {
        FutureObserver<TiRegion, Pdpb.GetRegionResponse> responseObserver = new FutureObserver<TiRegion, Pdpb.GetRegionResponse>(resp -> new TiRegion(resp.getRegion(), resp.getLeader(), this.conf.getIsolationLevel(), this.conf.getCommandPriority()));
        Supplier<Pdpb.GetRegionRequest> request = () -> Pdpb.GetRegionRequest.newBuilder().setHeader(this.header).setRegionKey(key).build();
        PDErrorHandler<Pdpb.GetRegionResponse> handler = new PDErrorHandler<Pdpb.GetRegionResponse>(PDErrorHandler.getRegionResponseErrorExtractor, this);
        this.callAsyncWithRetry(backOffer, PDGrpc.getGetRegionMethod(), request, responseObserver, handler);
        return responseObserver.getFuture();
    }

    @Override
    public TiRegion getRegionByID(BackOffer backOffer, long id) {
        Supplier<Pdpb.GetRegionByIDRequest> request = () -> Pdpb.GetRegionByIDRequest.newBuilder().setHeader(this.header).setRegionId(id).build();
        PDErrorHandler<Pdpb.GetRegionResponse> handler = new PDErrorHandler<Pdpb.GetRegionResponse>(PDErrorHandler.getRegionResponseErrorExtractor, this);
        Pdpb.GetRegionResponse resp = this.callWithRetry(backOffer, PDGrpc.getGetRegionByIDMethod(), request, handler);
        return new TiRegion(resp.getRegion(), resp.getLeader(), this.conf.getIsolationLevel(), this.conf.getCommandPriority());
    }

    @Override
    public Future<TiRegion> getRegionByIDAsync(BackOffer backOffer, long id) {
        FutureObserver<TiRegion, Pdpb.GetRegionResponse> responseObserver = new FutureObserver<TiRegion, Pdpb.GetRegionResponse>(resp -> new TiRegion(resp.getRegion(), resp.getLeader(), this.conf.getIsolationLevel(), this.conf.getCommandPriority()));
        Supplier<Pdpb.GetRegionByIDRequest> request = () -> Pdpb.GetRegionByIDRequest.newBuilder().setHeader(this.header).setRegionId(id).build();
        PDErrorHandler<Pdpb.GetRegionResponse> handler = new PDErrorHandler<Pdpb.GetRegionResponse>(PDErrorHandler.getRegionResponseErrorExtractor, this);
        this.callAsyncWithRetry(backOffer, PDGrpc.getGetRegionByIDMethod(), request, responseObserver, handler);
        return responseObserver.getFuture();
    }

    private Supplier<Pdpb.GetStoreRequest> buildGetStoreReq(long storeId) {
        return () -> Pdpb.GetStoreRequest.newBuilder().setHeader(this.header).setStoreId(storeId).build();
    }

    private Supplier<Pdpb.GetAllStoresRequest> buildGetAllStoresReq() {
        return () -> Pdpb.GetAllStoresRequest.newBuilder().setHeader(this.header).build();
    }

    private <T> PDErrorHandler<Pdpb.GetStoreResponse> buildPDErrorHandler() {
        return new PDErrorHandler<Pdpb.GetStoreResponse>(r -> r.getHeader().hasError() ? PDError.buildFromPdpbError(r.getHeader().getError()) : null, this);
    }

    @Override
    public Metapb.Store getStore(BackOffer backOffer, long storeId) {
        return this.callWithRetry(backOffer, PDGrpc.getGetStoreMethod(), this.buildGetStoreReq(storeId), this.buildPDErrorHandler()).getStore();
    }

    @Override
    public Future<Metapb.Store> getStoreAsync(BackOffer backOffer, long storeId) {
        FutureObserver<Metapb.Store, Pdpb.GetStoreResponse> responseObserver = new FutureObserver<Metapb.Store, Pdpb.GetStoreResponse>(Pdpb.GetStoreResponse::getStore);
        this.callAsyncWithRetry(backOffer, PDGrpc.getGetStoreMethod(), this.buildGetStoreReq(storeId), responseObserver, this.buildPDErrorHandler());
        return responseObserver.getFuture();
    }

    @Override
    public List<Metapb.Store> getAllStores(BackOffer backOffer) {
        return this.callWithRetry(backOffer, PDGrpc.getGetAllStoresMethod(), this.buildGetAllStoresReq(), new PDErrorHandler<Pdpb.GetAllStoresResponse>(r -> r.getHeader().hasError() ? PDError.buildFromPdpbError(r.getHeader().getError()) : null, this)).getStoresList();
    }

    @Override
    public void close() throws InterruptedException {
        this.etcdClient.close();
        if (this.service != null) {
            this.service.shutdownNow();
        }
        if (this.tiflashReplicaService != null) {
            this.tiflashReplicaService.shutdownNow();
        }
    }

    @VisibleForTesting
    Pdpb.RequestHeader getHeader() {
        return this.header;
    }

    @VisibleForTesting
    LeaderWrapper getLeaderWrapper() {
        return this.leaderWrapper;
    }

    private Pdpb.GetMembersResponse getMembers(URI url) {
        try {
            ManagedChannel probChan = this.channelFactory.getChannel(url.getHost() + ":" + url.getPort());
            PDGrpc.PDBlockingStub stub = PDGrpc.newBlockingStub(probChan);
            Pdpb.GetMembersRequest request = Pdpb.GetMembersRequest.newBuilder().setHeader(Pdpb.RequestHeader.getDefaultInstance()).build();
            Pdpb.GetMembersResponse resp = stub.getMembers(request);
            if (resp != null && resp.getLeader().getMemberId() == 0L) {
                return null;
            }
            return resp;
        }
        catch (Exception e) {
            this.logger.warn("failed to get member from pd server.", (Throwable)e);
            return null;
        }
    }

    synchronized boolean switchLeader(List<String> leaderURLs) {
        if (leaderURLs.isEmpty()) {
            return false;
        }
        String leaderUrlStr = leaderURLs.get(0);
        if (this.leaderWrapper != null && leaderUrlStr.equals(this.leaderWrapper.getLeaderInfo())) {
            return true;
        }
        return this.createLeaderWrapper(leaderUrlStr);
    }

    private boolean createLeaderWrapper(String leaderUrlStr) {
        try {
            URI newLeader = PDUtils.addrToUrl(leaderUrlStr);
            leaderUrlStr = newLeader.getHost() + ":" + newLeader.getPort();
            if (this.leaderWrapper != null && leaderUrlStr.equals(this.leaderWrapper.getLeaderInfo())) {
                return true;
            }
            ManagedChannel clientChannel = this.channelFactory.getChannel(leaderUrlStr);
            this.leaderWrapper = new LeaderWrapper(leaderUrlStr, PDGrpc.newBlockingStub(clientChannel), PDGrpc.newStub(clientChannel), System.nanoTime());
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Error updating leader. " + leaderUrlStr, (Throwable)e);
            return false;
        }
        this.logger.info(String.format("Switched to new leader: %s", this.leaderWrapper));
        return true;
    }

    public void updateLeader() {
        for (URI url : this.pdAddrs) {
            Pdpb.GetMembersResponse resp = this.getMembers(url);
            if (resp == null || !this.switchLeader(resp.getLeader().getClientUrlsList())) continue;
            return;
        }
        throw new TiClientInternalException("already tried all address on file, but not leader found yet.");
    }

    public void updateTiFlashReplicaStatus() {
        ByteSequence prefix = ByteSequence.from(TIFLASH_TABLE_SYNC_PROGRESS_PATH, StandardCharsets.UTF_8);
        for (int i = 0; i < 5; ++i) {
            GetResponse getResp;
            CompletableFuture<GetResponse> resp;
            try {
                resp = this.etcdClient.getKVClient().get(prefix, GetOption.newBuilder().withPrefix(prefix).build());
            }
            catch (Exception e) {
                this.logger.info("get tiflash table replica sync progress failed, continue checking.", (Throwable)e);
                continue;
            }
            try {
                getResp = resp.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                throw new GrpcException("failed to update tiflash replica", e);
            }
            ConcurrentHashMap<Long, Double> progressMap = new ConcurrentHashMap<Long, Double>();
            for (KeyValue kv : getResp.getKvs()) {
                double progress;
                long tableId;
                try {
                    tableId = Long.parseLong(kv.getKey().toString().substring(TIFLASH_TABLE_SYNC_PROGRESS_PATH.length()));
                }
                catch (Exception e) {
                    this.logger.debug("invalid tiflash table replica sync progress key. key = " + kv.getKey().toString());
                    continue;
                }
                try {
                    progress = Double.parseDouble(kv.getValue().toString());
                }
                catch (Exception e) {
                    this.logger.info("invalid tiflash table replica sync progress value. value = " + kv.getValue().toString());
                    continue;
                }
                progressMap.put(tableId, progress);
            }
            this.tiflashReplicaMap = progressMap;
            break;
        }
    }

    public double getTiFlashReplicaProgress(long tableId) {
        return this.tiflashReplicaMap.getOrDefault(tableId, 0.0);
    }

    @Override
    protected PDGrpc.PDBlockingStub getBlockingStub() {
        if (this.leaderWrapper == null) {
            throw new GrpcException("PDClient may not be initialized");
        }
        return (PDGrpc.PDBlockingStub)this.leaderWrapper.getBlockingStub().withDeadlineAfter(this.getConf().getTimeout(), this.getConf().getTimeoutUnit());
    }

    @Override
    protected PDGrpc.PDStub getAsyncStub() {
        if (this.leaderWrapper == null) {
            throw new GrpcException("PDClient may not be initialized");
        }
        return (PDGrpc.PDStub)this.leaderWrapper.getAsyncStub().withDeadlineAfter(this.getConf().getTimeout(), this.getConf().getTimeoutUnit());
    }

    private void initCluster() {
        URI u;
        Pdpb.GetMembersResponse resp = null;
        List<URI> pdAddrs = this.getConf().getPdAddrs();
        Iterator<URI> iterator = pdAddrs.iterator();
        while (iterator.hasNext() && (resp = this.getMembers(u = iterator.next())) == null) {
        }
        Preconditions.checkNotNull(resp, "Failed to init client for PD cluster.");
        long clusterId = resp.getHeader().getClusterId();
        this.header = Pdpb.RequestHeader.newBuilder().setClusterId(clusterId).build();
        this.tsoReq = Pdpb.TsoRequest.newBuilder().setHeader(this.header).setCount(1).build();
        this.pdAddrs = pdAddrs;
        this.etcdClient = Client.builder().endpoints(pdAddrs).build();
        this.tiflashReplicaMap = new ConcurrentHashMap<Long, Double>();
        this.createLeaderWrapper(resp.getLeader().getClientUrls(0));
        this.service = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        this.service.scheduleAtFixedRate(() -> {
            try {
                this.updateLeader();
            }
            catch (Exception e) {
                this.logger.warn("Update leader failed", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.tiflashReplicaService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        this.tiflashReplicaService.scheduleAtFixedRate(this::updateTiFlashReplicaStatus, 10L, 10L, TimeUnit.SECONDS);
    }

    static class LeaderWrapper {
        private final String leaderInfo;
        private final PDGrpc.PDBlockingStub blockingStub;
        private final PDGrpc.PDStub asyncStub;
        private final long createTime;

        LeaderWrapper(String leaderInfo, PDGrpc.PDBlockingStub blockingStub, PDGrpc.PDStub asyncStub, long createTime) {
            this.leaderInfo = leaderInfo;
            this.blockingStub = blockingStub;
            this.asyncStub = asyncStub;
            this.createTime = createTime;
        }

        String getLeaderInfo() {
            return this.leaderInfo;
        }

        PDGrpc.PDBlockingStub getBlockingStub() {
            return this.blockingStub;
        }

        PDGrpc.PDStub getAsyncStub() {
            return this.asyncStub;
        }

        long getCreateTime() {
            return this.createTime;
        }

        public String toString() {
            return "[leaderInfo: " + this.leaderInfo + "]";
        }
    }
}

