/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.tikv.BytePairWrapper;
import com.pingcap.tikv.KVClient;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.TiSession;
import com.pingcap.tikv.columnar.TiChunk;
import com.pingcap.tikv.key.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.operation.iterator.ConcreteScanIterator;
import com.pingcap.tikv.operation.iterator.CoprocessorIterator;
import com.pingcap.tikv.operation.iterator.IndexScanIterator;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.RangeSplitter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class Snapshot {
    private final TiTimestamp timestamp;
    private final TiSession session;
    private final TiConfiguration conf;

    public Snapshot(@Nonnull TiTimestamp timestamp, TiConfiguration conf) {
        this.timestamp = timestamp;
        this.conf = conf;
        this.session = TiSession.getInstance(conf);
    }

    public TiSession getSession() {
        return this.session;
    }

    public long getVersion() {
        return this.timestamp.getVersion();
    }

    public TiTimestamp getTimestamp() {
        return this.timestamp;
    }

    public byte[] get(byte[] key) {
        ByteString keyString = ByteString.copyFrom(key);
        ByteString value = this.get(keyString);
        return value.toByteArray();
    }

    public ByteString get(ByteString key) {
        try (KVClient client = new KVClient(this.session.getConf(), this.session.getRegionStoreClientBuilder(), this.session.getThreadPoolForBatchGet());){
            ByteString byteString = client.get(key, this.timestamp.getVersion());
            return byteString;
        }
    }

    public List<BytePairWrapper> batchGet(int backOffer, List<byte[]> keys) {
        ArrayList<ByteString> list = new ArrayList<ByteString>();
        for (byte[] key : keys) {
            list.add(ByteString.copyFrom(key));
        }
        try (KVClient client = new KVClient(this.session.getConf(), this.session.getRegionStoreClientBuilder(), this.session.getThreadPoolForBatchGet());){
            List<Kvrpcpb.KvPair> kvPairList = client.batchGet(ConcreteBackOffer.newCustomBackOff(backOffer), list, this.timestamp.getVersion());
            List<BytePairWrapper> list2 = kvPairList.stream().map(kvPair -> new BytePairWrapper(kvPair.getKey().toByteArray(), kvPair.getValue().toByteArray())).collect(Collectors.toList());
            return list2;
        }
    }

    public Iterator<TiChunk> tableReadChunk(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks, int numOfRows) {
        if (dagRequest.isDoubleRead()) {
            throw new UnsupportedOperationException("double read case should first read handle in row-wise fashion");
        }
        return CoprocessorIterator.getTiChunkIterator(dagRequest, tasks, this.getSession(), numOfRows);
    }

    public Iterator<Row> tableReadRow(TiDAGRequest dagRequest, long physicalId) {
        return this.tableReadRow(dagRequest, RangeSplitter.newSplitter(this.session.getRegionManager()).splitRangeByRegion(dagRequest.getRangesByPhysicalId(physicalId), dagRequest.getStoreType()));
    }

    private Iterator<Row> tableReadRow(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks) {
        if (dagRequest.isDoubleRead()) {
            CoprocessorIterator<Handle> iter = CoprocessorIterator.getHandleIterator(dagRequest, tasks, this.getSession());
            return new IndexScanIterator(this, dagRequest, iter);
        }
        return CoprocessorIterator.getRowIterator(dagRequest, tasks, this.getSession());
    }

    public Iterator<Handle> indexHandleRead(TiDAGRequest dagRequest, List<RangeSplitter.RegionTask> tasks) {
        return CoprocessorIterator.getHandleIterator(dagRequest, tasks, this.session);
    }

    public Iterator<Kvrpcpb.KvPair> scanPrefix(ByteString prefix) {
        ByteString nextPrefix = Key.toRawKey(prefix).nextPrefix().toByteString();
        return new ConcreteScanIterator(this.session.getConf(), this.session.getRegionStoreClientBuilder(), prefix, nextPrefix, this.timestamp.getVersion());
    }

    public TiConfiguration getConf() {
        return this.conf;
    }
}

