/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.TiSession;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiBatchWriteException;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.TxnKVClient;
import com.pingcap.tikv.txn.type.ClientRPCResult;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.LogDesensitization;
import com.pingcap.tikv.util.Pair;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class TTLManager {
    public static final int MANAGED_LOCK_TTL = 20000;
    private static final Logger LOG = LoggerFactory.getLogger(TTLManager.class);
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_CLOSED = 2;
    private static final int SCHEDULER_PERIOD = 10000;
    private static final int SCHEDULER_INITIAL_DELAY = 5000;
    private final long startTS;
    private final ByteString primaryLock;
    private final TxnKVClient kvClient;
    private final RegionManager regionManager;
    private final ScheduledExecutorService scheduler;
    private final AtomicInteger state;

    public TTLManager(TiConfiguration conf, long startTS, byte[] primaryKey) {
        this.startTS = startTS;
        this.primaryLock = ByteString.copyFrom(primaryKey);
        this.state = new AtomicInteger(0);
        this.kvClient = TiSession.getInstance(conf).createTxnClient();
        this.regionManager = this.kvClient.getRegionManager();
        this.scheduler = new ScheduledThreadPoolExecutor(1, new BasicThreadFactory.Builder().namingPattern("ttl-manager-pool-%d").daemon(false).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepAlive() {
        AtomicInteger atomicInteger = this.state;
        synchronized (atomicInteger) {
            if (this.state.compareAndSet(0, 1)) {
                this.scheduler.scheduleAtFixedRate(this::doKeepAlive, 5000L, 10000L, TimeUnit.MILLISECONDS);
            } else {
                LOG.warn("keepAlive failed state={} key={}", (Object)this.state.get(), (Object)LogDesensitization.hide(KeyUtils.formatBytes(this.primaryLock)));
            }
        }
    }

    public static long calculateUptime(TxnKVClient kvClient, long startTS) {
        return kvClient.getTimestamp().getPhysical() - TiTimestamp.extractPhysical(startTS);
    }

    private void doKeepAlive() {
        ConcreteBackOffer bo = ConcreteBackOffer.newCustomBackOff(20000);
        long uptime = TTLManager.calculateUptime(this.kvClient, this.startTS);
        long ttl = uptime + 20000L;
        LOG.info("doKeepAlive key={} uptime={} ttl={}", new Object[]{LogDesensitization.hide(KeyUtils.formatBytes(this.primaryLock)), uptime, ttl});
        try {
            this.sendTxnHeartBeat(bo, ttl);
            LOG.info("doKeepAlive success");
        }
        catch (Exception e) {
            LOG.warn("doKeepAlive error", (Throwable)e);
        }
    }

    private void sendTxnHeartBeat(BackOffer bo, long ttl) {
        Pair<TiRegion, Metapb.Store> pair = this.regionManager.getRegionStorePairByKey(this.primaryLock);
        TiRegion tiRegion = (TiRegion)pair.first;
        Metapb.Store store = (Metapb.Store)pair.second;
        ClientRPCResult result = this.kvClient.txnHeartBeat(bo, this.primaryLock, this.startTS, ttl, tiRegion, store);
        if (!result.isSuccess() && !result.isRetry()) {
            throw new TiBatchWriteException("sendTxnHeartBeat error", result.getException());
        }
        if (result.isRetry()) {
            try {
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(String.format("sendTxnHeartBeat failed, regionId=%s", tiRegion.getId()), result.getException()));
                this.regionManager.invalidateStore(store.getId());
                this.regionManager.invalidateRegion(tiRegion);
                this.sendTxnHeartBeat(bo, ttl);
            }
            catch (GrpcException e) {
                String errorMsg = String.format("sendTxnHeartBeat error, regionId=%s, detail=%s", tiRegion.getId(), e.getMessage());
                throw new TiBatchWriteException(errorMsg, e);
            }
        }
        LOG.debug("sendTxnHeartBeat success key={} ttl={} success", (Object)LogDesensitization.hide(KeyUtils.formatBytes(this.primaryLock)), (Object)ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        AtomicInteger atomicInteger = this.state;
        synchronized (atomicInteger) {
            if (this.state.compareAndSet(1, 2)) {
                this.scheduler.shutdown();
            }
        }
    }
}

