/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.pd.PDUtils;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.types.Converter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.tikv.kvproto.Kvrpcpb;

public class TiConfiguration
implements Serializable {
    private static final DateTimeZone DEF_TIMEZONE = Converter.getLocalTimezone();
    private static final int DEF_TIMEOUT = 10;
    private static final TimeUnit DEF_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private static final int DEF_SCAN_BATCH_SIZE = 10480;
    private static final boolean DEF_IGNORE_TRUNCATE = true;
    private static final boolean DEF_TRUNCATE_AS_WARNING = false;
    private static final int DEF_MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int DEF_INDEX_SCAN_BATCH_SIZE = 20000;
    private static final int DEF_REGION_SCAN_DOWNGRADE_THRESHOLD = 10000000;
    private static final int MAX_REQUEST_KEY_RANGE_SIZE = 20000;
    private static final int DEF_INDEX_SCAN_CONCURRENCY = 5;
    private static final int DEF_TABLE_SCAN_CONCURRENCY = 512;
    private static final int DEF_BATCH_GET_CONCURRENCY = 20;
    private static final int DEF_BATCH_PUT_CONCURRENCY = 20;
    private static final int DEF_BATCH_DELETE_CONCURRENCY = 20;
    private static final int DEF_BATCH_SCAN_CONCURRENCY = 5;
    private static final int DEF_DELETE_RANGE_CONCURRENCY = 20;
    private static final Kvrpcpb.CommandPri DEF_COMMAND_PRIORITY = Kvrpcpb.CommandPri.Low;
    private static final Kvrpcpb.IsolationLevel DEF_ISOLATION_LEVEL = Kvrpcpb.IsolationLevel.SI;
    private static final boolean DEF_SHOW_ROWID = false;
    private static final String DEF_DB_PREFIX = "";
    private static final boolean DEF_WRITE_ENABLE = true;
    private static final boolean DEF_WRITE_ALLOW_SPARK_SQL = false;
    private static final boolean DEF_WRITE_WITHOUT_LOCK_TABLE = false;
    private static final int DEF_TIKV_REGION_SPLIT_SIZE_IN_MB = 96;
    private static final int DEF_PARTITION_PER_SPLIT = 10;
    private static final int DEF_KV_CLIENT_CONCURRENCY = 10;
    private static final List<TiStoreType> DEF_ISOLATION_READ_ENGINES = ImmutableList.of(TiStoreType.TiKV, TiStoreType.TiFlash);
    private int timeout = 10;
    private TimeUnit timeoutUnit = DEF_TIMEOUT_UNIT;
    private boolean ignoreTruncate = true;
    private boolean truncateAsWarning = false;
    private int maxFrameSize = Integer.MAX_VALUE;
    private List<URI> pdAddrs = new ArrayList<URI>();
    private int indexScanBatchSize = 20000;
    private int downgradeThreshold = 10000000;
    private int indexScanConcurrency = 5;
    private int tableScanConcurrency = 512;
    private int batchGetConcurrency = 20;
    private int batchPutConcurrency = 20;
    private int batchDeleteConcurrency = 20;
    private int batchScanConcurrency = 5;
    private int deleteRangeConcurrency = 20;
    private Kvrpcpb.CommandPri commandPriority = DEF_COMMAND_PRIORITY;
    private Kvrpcpb.IsolationLevel isolationLevel = DEF_ISOLATION_LEVEL;
    private int maxRequestKeyRangeSize = 20000;
    private boolean showRowId = false;
    private String dbPrefix = "";
    private boolean writeAllowSparkSQL = false;
    private boolean writeEnable = true;
    private boolean writeWithoutLockTable = false;
    private int tikvRegionSplitSizeInMB = 96;
    private int partitionPerSplit = 10;
    private int kvClientConcurrency = 10;
    private List<TiStoreType> isolationReadEngines = DEF_ISOLATION_READ_ENGINES;

    public static TiConfiguration createDefault(String pdAddrsStr) {
        Objects.requireNonNull(pdAddrsStr, "pdAddrsStr is null");
        TiConfiguration conf = new TiConfiguration();
        conf.pdAddrs = TiConfiguration.strToURI(pdAddrsStr);
        return conf;
    }

    private static List<URI> strToURI(String addressStr) {
        Objects.requireNonNull(addressStr);
        Object[] addrs = addressStr.split(",");
        Arrays.sort(addrs);
        return PDUtils.addrsToUrls((String[])addrs);
    }

    public static <E> String listToString(List<E> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i).toString());
            if (i == list.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public DateTimeZone getLocalTimeZone() {
        return DEF_TIMEZONE;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public TiConfiguration setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public TiConfiguration setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public List<URI> getPdAddrs() {
        return this.pdAddrs;
    }

    public String getPdAddrsString() {
        return TiConfiguration.listToString(this.pdAddrs);
    }

    public int getScanBatchSize() {
        return 10480;
    }

    boolean isIgnoreTruncate() {
        return this.ignoreTruncate;
    }

    public TiConfiguration setIgnoreTruncate(boolean ignoreTruncate) {
        this.ignoreTruncate = ignoreTruncate;
        return this;
    }

    boolean isTruncateAsWarning() {
        return this.truncateAsWarning;
    }

    public TiConfiguration setTruncateAsWarning(boolean truncateAsWarning) {
        this.truncateAsWarning = truncateAsWarning;
        return this;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public TiConfiguration setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        return this;
    }

    public int getIndexScanBatchSize() {
        return this.indexScanBatchSize;
    }

    public void setIndexScanBatchSize(int indexScanBatchSize) {
        this.indexScanBatchSize = indexScanBatchSize;
    }

    public int getIndexScanConcurrency() {
        return this.indexScanConcurrency;
    }

    public void setIndexScanConcurrency(int indexScanConcurrency) {
        this.indexScanConcurrency = indexScanConcurrency;
    }

    public int getTableScanConcurrency() {
        return this.tableScanConcurrency;
    }

    public void setTableScanConcurrency(int tableScanConcurrency) {
        this.tableScanConcurrency = tableScanConcurrency;
    }

    public int getBatchGetConcurrency() {
        return this.batchGetConcurrency;
    }

    public TiConfiguration setBatchGetConcurrency(int batchGetConcurrency) {
        this.batchGetConcurrency = batchGetConcurrency;
        return this;
    }

    public int getBatchPutConcurrency() {
        return this.batchPutConcurrency;
    }

    public TiConfiguration setBatchPutConcurrency(int batchPutConcurrency) {
        this.batchPutConcurrency = batchPutConcurrency;
        return this;
    }

    public int getBatchDeleteConcurrency() {
        return this.batchDeleteConcurrency;
    }

    public TiConfiguration setBatchDeleteConcurrency(int batchDeleteConcurrency) {
        this.batchDeleteConcurrency = batchDeleteConcurrency;
        return this;
    }

    public int getBatchScanConcurrency() {
        return this.batchScanConcurrency;
    }

    public TiConfiguration setBatchScanConcurrency(int batchScanConcurrency) {
        this.batchScanConcurrency = batchScanConcurrency;
        return this;
    }

    public int getDeleteRangeConcurrency() {
        return this.deleteRangeConcurrency;
    }

    public TiConfiguration setDeleteRangeConcurrency(int deleteRangeConcurrency) {
        this.deleteRangeConcurrency = deleteRangeConcurrency;
        return this;
    }

    public Kvrpcpb.CommandPri getCommandPriority() {
        return this.commandPriority;
    }

    public void setCommandPriority(Kvrpcpb.CommandPri commandPriority) {
        this.commandPriority = commandPriority;
    }

    public Kvrpcpb.IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(Kvrpcpb.IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public int getMaxRequestKeyRangeSize() {
        return this.maxRequestKeyRangeSize;
    }

    public void setMaxRequestKeyRangeSize(int maxRequestKeyRangeSize) {
        if (maxRequestKeyRangeSize <= 0) {
            throw new IllegalArgumentException("Key range size cannot be less than 1");
        }
        this.maxRequestKeyRangeSize = maxRequestKeyRangeSize;
    }

    public void setShowRowId(boolean flag) {
        this.showRowId = flag;
    }

    public boolean ifShowRowId() {
        return this.showRowId;
    }

    public String getDBPrefix() {
        return this.dbPrefix;
    }

    public void setDBPrefix(String dbPrefix) {
        this.dbPrefix = dbPrefix;
    }

    public boolean isWriteEnable() {
        return this.writeEnable;
    }

    public void setWriteEnable(boolean writeEnable) {
        this.writeEnable = writeEnable;
    }

    public boolean isWriteWithoutLockTable() {
        return this.writeWithoutLockTable;
    }

    public void setWriteWithoutLockTable(boolean writeWithoutLockTable) {
        this.writeWithoutLockTable = writeWithoutLockTable;
    }

    public boolean isWriteAllowSparkSQL() {
        return this.writeAllowSparkSQL;
    }

    public void setWriteAllowSparkSQL(boolean writeAllowSparkSQL) {
        this.writeAllowSparkSQL = writeAllowSparkSQL;
    }

    public int getTikvRegionSplitSizeInMB() {
        return this.tikvRegionSplitSizeInMB;
    }

    public void setTikvRegionSplitSizeInMB(int tikvRegionSplitSizeInMB) {
        this.tikvRegionSplitSizeInMB = tikvRegionSplitSizeInMB;
    }

    public int getDowngradeThreshold() {
        return this.downgradeThreshold;
    }

    public void setDowngradeThreshold(int downgradeThreshold) {
        this.downgradeThreshold = downgradeThreshold;
    }

    public int getPartitionPerSplit() {
        return this.partitionPerSplit;
    }

    public void setPartitionPerSplit(int partitionPerSplit) {
        this.partitionPerSplit = partitionPerSplit;
    }

    public List<TiStoreType> getIsolationReadEngines() {
        return this.isolationReadEngines;
    }

    public void setIsolationReadEngines(List<TiStoreType> isolationReadEngines) {
        this.isolationReadEngines = isolationReadEngines;
    }

    public int getKvClientConcurrency() {
        return this.kvClientConcurrency;
    }

    public void setKvClientConcurrency(int kvClientConcurrency) {
        this.kvClientConcurrency = kvClientConcurrency;
    }
}

