/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.event;

import com.pingcap.tikv.region.TiRegion;
import java.io.Serializable;

public class CacheInvalidateEvent
implements Serializable {
    private final TiRegion region;
    private final CacheType cacheType;
    private boolean invalidateRegion;
    private boolean invalidateStore;

    public CacheInvalidateEvent(TiRegion region, boolean updateRegion, boolean updateStore, CacheType type) {
        this.region = region;
        this.cacheType = type;
        if (updateRegion) {
            this.invalidateRegion();
        }
        if (updateStore) {
            this.invalidateStore();
        }
    }

    public TiRegion getRegion() {
        return this.region;
    }

    public long getStoreId() {
        return this.region.getLeader().getStoreId();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CacheInvalidateEvent) {
            CacheInvalidateEvent event = (CacheInvalidateEvent)obj;
            return event.getRegion().equals(this.getRegion()) && event.getCacheType() == this.getCacheType();
        }
        return false;
    }

    public int hashCode() {
        int result = 1106;
        result += result * 31 + this.getRegion().hashCode();
        result += result * 31 + this.getCacheType().name().hashCode();
        return result;
    }

    public void invalidateRegion() {
        this.invalidateRegion = true;
    }

    public void invalidateStore() {
        this.invalidateStore = true;
    }

    public boolean shouldUpdateRegion() {
        return this.invalidateRegion;
    }

    public boolean shouldUpdateStore() {
        return this.invalidateStore;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public String toString() {
        return String.format("RegionId=%d,StoreId=%d,Type=%s", this.region.getId(), this.region.getLeader().getStoreId(), this.cacheType.name());
    }

    public static enum CacheType implements Serializable
    {
        REGION_STORE,
        REQ_FAILED,
        LEADER;

    }
}

