/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.expression.Constant;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.FuncCallExprEval;
import com.pingcap.tikv.expression.Visitor;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class FuncCallExpr
extends Expression {
    private final Expression child;
    private final Type funcTp;

    public FuncCallExpr(Expression expr, Type funcTp) {
        this.child = expr;
        this.funcTp = funcTp;
    }

    public static FuncCallExpr year(Expression expr) {
        return new FuncCallExpr(expr, Type.YEAR);
    }

    public Type getFuncTp() {
        return this.funcTp;
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.child);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public Expression getExpression() {
        return this.child;
    }

    private String getFuncString() {
        if (this.funcTp == Type.YEAR) {
            return "year";
        }
        return "";
    }

    public String toString() {
        return String.format("%s(%s)", this.getFuncString(), this.getExpression());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FuncCallExpr)) {
            return false;
        }
        FuncCallExpr that = (FuncCallExpr)other;
        return Objects.equals(this.child, that.child);
    }

    public int hashCode() {
        return Objects.hashCode(this.child);
    }

    public Constant eval(Constant literal) {
        Function<Constant, Constant> evalFn = FuncCallExprEval.getEvalFn(this.funcTp);
        if (evalFn != null) {
            return evalFn.apply(literal);
        }
        return literal;
    }

    public static enum Type {
        YEAR;

    }
}

