/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.types.IntegerType;
import java.util.List;
import java.util.Objects;

public class LogicalBinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final Type compType;

    public LogicalBinaryExpression(Type type, Expression left, Expression right) {
        super(IntegerType.BOOLEAN);
        this.left = Objects.requireNonNull(left, "left expression is null");
        this.right = Objects.requireNonNull(right, "right expression is null");
        this.compType = Objects.requireNonNull(type, "type is null");
    }

    public static LogicalBinaryExpression and(Expression left, Expression right) {
        return new LogicalBinaryExpression(Type.AND, left, right);
    }

    public static LogicalBinaryExpression or(Expression left, Expression right) {
        return new LogicalBinaryExpression(Type.OR, left, right);
    }

    public static LogicalBinaryExpression xor(Expression left, Expression right) {
        return new LogicalBinaryExpression(Type.XOR, left, right);
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.getLeft(), this.getRight());
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Type getCompType() {
        return this.compType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogicalBinaryExpression)) {
            return false;
        }
        LogicalBinaryExpression that = (LogicalBinaryExpression)other;
        return this.compType == that.compType && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.compType, this.left, this.right});
    }

    public String toString() {
        return String.format("[%s %s %s]", new Object[]{this.getLeft(), this.getCompType(), this.getRight()});
    }

    public static enum Type {
        AND,
        OR,
        XOR;

    }
}

