/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.types.IntegerType;
import java.util.List;
import java.util.Objects;

public class Not
extends Expression {
    private final Expression expression;

    public Not(Expression expression) {
        super(IntegerType.BOOLEAN);
        this.resolved = true;
        this.expression = Objects.requireNonNull(expression, "expression is null");
    }

    public static Not not(Expression expression) {
        return new Not(expression);
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.expression);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public String toString() {
        return String.format("Not(%s)", this.getExpression());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Not)) {
            return false;
        }
        Not that = (Not)other;
        return Objects.equals(this.expression, that.expression);
    }

    public int hashCode() {
        return Objects.hashCode(this.expression);
    }
}

