/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.com.google.common.base.Joiner;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.exception.TypeException;
import com.pingcap.tikv.key.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.meta.TiIndexColumn;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.row.Row;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.IntegerType;
import java.util.List;

public class IndexKey
extends Key {
    private static final byte[] IDX_PREFIX_SEP = new byte[]{95, 105};
    private final long tableId;
    private final long indexId;
    private final Key[] dataKeys;

    private IndexKey(long tableId, long indexId, Key[] dataKeys) {
        super(IndexKey.encode(tableId, indexId, dataKeys));
        this.tableId = tableId;
        this.indexId = indexId;
        this.dataKeys = dataKeys;
    }

    public static IndexKey toIndexKey(long tableId, long indexId, Key ... dataKeys) {
        return new IndexKey(tableId, indexId, dataKeys);
    }

    public static EncodeIndexDataResult encodeIndexDataValues(Row row, List<TiIndexColumn> indexColumns, Handle handle, boolean appendHandleIfContainsNull, TiTableInfo tableInfo) {
        boolean appendHandle = false;
        if (handle.isInt() && appendHandleIfContainsNull) {
            for (TiIndexColumn col : indexColumns) {
                DataType colTp = tableInfo.getColumn(col.getOffset()).getType();
                if (row.get(col.getOffset(), colTp) != null) continue;
                appendHandle = true;
                break;
            }
        }
        Key[] keys = new Key[indexColumns.size() + (appendHandle ? 1 : 0)];
        for (int i = 0; i < indexColumns.size(); ++i) {
            TiIndexColumn col = indexColumns.get(i);
            DataType colTp = tableInfo.getColumn(col.getOffset()).getType();
            TypedKey key = TypedKey.toTypedKey(row.get(col.getOffset(), colTp), colTp, (int)col.getLength());
            keys[i] = key;
        }
        if (appendHandle) {
            TypedKey key = TypedKey.toTypedKey(handle, IntegerType.BIGINT);
            keys[keys.length - 1] = key;
        }
        return new EncodeIndexDataResult(keys, appendHandle);
    }

    private static byte[] encode(long tableId, long indexId, Key[] dataKeys) {
        CodecDataOutput cdo = new CodecDataOutput();
        cdo.write(TBL_PREFIX);
        Codec.IntegerCodec.writeLong(cdo, tableId);
        cdo.write(IDX_PREFIX_SEP);
        Codec.IntegerCodec.writeLong(cdo, indexId);
        for (Key key : dataKeys) {
            if (key == null) {
                throw new TypeException("key cannot be null");
            }
            cdo.write(key.getBytes());
        }
        return cdo.toBytes();
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public Key[] getDataKeys() {
        return this.dataKeys;
    }

    @Override
    public String toString() {
        return String.format("[%s]", Joiner.on(",").useForNull("null").join(this.dataKeys));
    }

    public static class EncodeIndexDataResult {
        public Key[] keys;
        public boolean appendHandle;

        public EncodeIndexDataResult(Key[] keys, boolean appendHandle) {
            this.keys = keys;
            this.appendHandle = appendHandle;
        }
    }
}

