/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.key;

import com.pingcap.com.google.common.collect.BoundType;
import com.pingcap.com.google.common.collect.Range;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.TypedKey;
import com.pingcap.tikv.predicates.IndexRange;

abstract class KeyRangeBuilder {
    private final IndexRange ir;
    private final Key pointKey;
    Key lPointKey;
    Key uPointKey;
    Key lKey;
    Key uKey;

    KeyRangeBuilder(IndexRange ir) {
        this.ir = ir;
        this.pointKey = ir.hasAccessKey() ? Key.toRawKey(ir.getAccessKey().getBytes()) : Key.EMPTY;
    }

    private void computeWithOutRange() {
        this.lPointKey = this.pointKey;
        this.uPointKey = this.pointKey.nextPrefix();
        this.lKey = Key.EMPTY;
        this.uKey = Key.EMPTY;
    }

    private void computeWithRange() {
        Range<TypedKey> range = this.ir.getRange();
        this.lPointKey = this.pointKey;
        this.uPointKey = this.pointKey;
        if (!range.hasLowerBound()) {
            this.lKey = Key.NULL;
        } else {
            this.lKey = Key.toRawKey(range.lowerEndpoint().getBytes());
            if (range.lowerBoundType().equals((Object)BoundType.OPEN)) {
                this.lKey = this.lKey.nextPrefix();
            }
        }
        if (!range.hasUpperBound()) {
            this.uKey = Key.MAX;
        } else {
            this.uKey = Key.toRawKey(range.upperEndpoint().getBytes());
            if (range.upperBoundType().equals((Object)BoundType.CLOSED)) {
                this.uKey = this.uKey.nextPrefix();
            }
        }
    }

    void computeKeyRange() {
        if (!this.ir.hasRange()) {
            this.computeWithOutRange();
        } else {
            this.computeWithRange();
        }
    }
}

