/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.meta;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingcap.tikv.meta.CIStr;
import com.pingcap.tikv.types.DataType;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TiIndexColumn
implements Serializable {
    private final String name;
    private final int offset;
    private final long length;

    @JsonCreator
    public TiIndexColumn(@JsonProperty(value="name") CIStr name, @JsonProperty(value="offset") int offset, @JsonProperty(value="length") long length) {
        this.name = name.getL();
        this.offset = offset;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isLengthUnspecified() {
        return DataType.isLengthUnSpecified(this.length);
    }

    public boolean isPrefixIndex() {
        return !this.isLengthUnspecified();
    }

    public boolean matchName(String otherName) {
        return this.name.equalsIgnoreCase(otherName);
    }

    public String toString() {
        return String.format("%s {name: %s, offset: %d, length: %d}", this.getClass().getSimpleName(), this.name, this.offset, this.length);
    }
}

