/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation.iterator;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public abstract class ScanIterator
implements Iterator<Kvrpcpb.KvPair> {
    protected final TiConfiguration conf;
    protected final RegionStoreClient.RegionStoreClientBuilder builder;
    protected List<Kvrpcpb.KvPair> currentCache;
    protected ByteString startKey;
    protected int index = -1;
    protected int limit;
    protected boolean endOfScan = false;
    protected Key endKey;
    protected boolean hasEndKey;
    protected boolean processingLastBatch = false;

    ScanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, int limit) {
        this.startKey = Objects.requireNonNull(startKey, "start key is null");
        this.endKey = Key.toRawKey(Objects.requireNonNull(endKey, "end key is null"));
        this.hasEndKey = !endKey.isEmpty();
        this.limit = limit;
        this.conf = conf;
        this.builder = builder;
    }

    abstract TiRegion loadCurrentRegionToCache() throws GrpcException;

    boolean cacheLoadFails() {
        if (this.endOfScan || this.processingLastBatch) {
            return true;
        }
        if (this.startKey == null) {
            return true;
        }
        try {
            Key lastKey;
            TiRegion region = this.loadCurrentRegionToCache();
            ByteString curRegionEndKey = region.getEndKey();
            if (this.currentCache == null) {
                return true;
            }
            this.index = 0;
            if (this.currentCache.size() < this.limit) {
                this.startKey = curRegionEndKey;
                lastKey = Key.toRawKey(curRegionEndKey);
            } else {
                if (this.currentCache.size() > this.limit) {
                    throw new IndexOutOfBoundsException("current cache size = " + this.currentCache.size() + ", larger than " + this.limit);
                }
                lastKey = Key.toRawKey(this.currentCache.get(this.currentCache.size() - 1).getKey());
                this.startKey = lastKey.next().toByteString();
            }
            if (this.hasEndKey && lastKey.compareTo(this.endKey) >= 0 || this.startKey.isEmpty()) {
                this.processingLastBatch = true;
                this.startKey = null;
            }
        }
        catch (Exception e) {
            throw new TiClientInternalException("Error scanning data from region.", e);
        }
        return false;
    }
}

