/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.region;

import com.pingcap.com.google.common.collect.RangeMap;
import com.pingcap.com.google.common.collect.TreeRangeMap;
import com.pingcap.tikv.ReadOnlyPDClient;
import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.event.CacheInvalidateEvent;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.KeyRangeUtils;
import com.pingcap.tikv.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class RegionManager {
    private static final Logger logger = LoggerFactory.getLogger(RegionManager.class);
    private final RegionCache cache;
    private final Function<CacheInvalidateEvent, Void> cacheInvalidateCallback;

    public RegionManager(ReadOnlyPDClient pdClient, Function<CacheInvalidateEvent, Void> cacheInvalidateCallback) {
        this.cache = new RegionCache(pdClient);
        this.cacheInvalidateCallback = cacheInvalidateCallback;
    }

    public RegionManager(ReadOnlyPDClient pdClient) {
        this.cache = new RegionCache(pdClient);
        this.cacheInvalidateCallback = null;
    }

    public Function<CacheInvalidateEvent, Void> getCacheInvalidateCallback() {
        return this.cacheInvalidateCallback;
    }

    public ReadOnlyPDClient getPDClient() {
        return this.cache.pdClient;
    }

    public TiRegion getRegionByKey(ByteString key) {
        return this.getRegionByKey(key, ConcreteBackOffer.newGetBackOff());
    }

    public TiRegion getRegionByKey(ByteString key, BackOffer backOffer) {
        return this.cache.getRegionByKey(key, backOffer);
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key, BackOffer backOffer) {
        return this.getRegionStorePairByKey(key, TiStoreType.TiKV, backOffer);
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key) {
        return this.getRegionStorePairByKey(key, TiStoreType.TiKV);
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key, TiStoreType storeType) {
        return this.getRegionStorePairByKey(key, storeType, ConcreteBackOffer.newGetBackOff());
    }

    public Pair<TiRegion, Metapb.Store> getRegionStorePairByKey(ByteString key, TiStoreType storeType, BackOffer backOffer) {
        TiRegion region = this.cache.getRegionByKey(key, backOffer);
        if (region == null) {
            throw new TiClientInternalException("Region not exist for key:" + KeyUtils.formatBytesUTF8(key));
        }
        if (!region.isValid()) {
            throw new TiClientInternalException("Region invalid: " + region.toString());
        }
        Metapb.Store store = null;
        if (storeType == TiStoreType.TiKV) {
            Metapb.Peer leader = region.getLeader();
            store = this.cache.getStoreById(leader.getStoreId(), backOffer);
        } else {
            block0: for (Metapb.Peer peer : region.getLearnerList()) {
                Metapb.Store s = this.getStoreById(peer.getStoreId(), backOffer);
                for (Metapb.StoreLabel label : s.getLabelsList()) {
                    if (!label.getKey().equals(storeType.getLabelKey()) || !label.getValue().equals(storeType.getLabelValue())) continue;
                    store = s;
                    break block0;
                }
            }
            if (store == null) {
                this.cache.invalidateRange(region.getStartKey(), region.getEndKey());
            }
        }
        if (store == null) {
            throw new TiClientInternalException("Cannot find valid store on " + (Object)((Object)storeType) + " for region " + region.toString());
        }
        return Pair.create(region, store);
    }

    public Metapb.Store getStoreById(long id) {
        return this.getStoreById(id, ConcreteBackOffer.newGetBackOff());
    }

    public Metapb.Store getStoreById(long id, BackOffer backOffer) {
        return this.cache.getStoreById(id, backOffer);
    }

    public void onRegionStale(TiRegion region) {
        this.cache.invalidateRegion(region);
    }

    public TiRegion updateLeader(TiRegion region, long storeId) {
        if (region.getLeader().getStoreId() == storeId) {
            return region;
        }
        TiRegion newRegion = region.switchPeer(storeId);
        if (this.cache.updateRegion(region, newRegion)) {
            return newRegion;
        }
        logger.warn("Cannot find peer when updating leader (" + region.getId() + "," + storeId + ")");
        return null;
    }

    public void onRequestFail(TiRegion region) {
        this.onRequestFail(region, region.getLeader().getStoreId());
    }

    private void onRequestFail(TiRegion region, long storeId) {
        this.cache.invalidateRegion(region);
        this.cache.invalidateAllRegionForStore(storeId);
    }

    public void invalidateStore(long storeId) {
        this.cache.invalidateStore(storeId);
    }

    public void invalidateRegion(TiRegion region) {
        this.cache.invalidateRegion(region);
    }

    public static class RegionCache {
        private final Map<Long, Metapb.Store> storeCache;
        private final RangeMap<Key, TiRegion> regionCache = TreeRangeMap.create();
        private final ReadOnlyPDClient pdClient;

        public RegionCache(ReadOnlyPDClient pdClient) {
            this.storeCache = new HashMap<Long, Metapb.Store>();
            this.pdClient = pdClient;
        }

        public synchronized TiRegion getRegionByKey(ByteString key, BackOffer backOffer) {
            TiRegion region = this.regionCache.get(KeyUtils.getEncodedKey(key));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("getRegionByKey key[%s] -> Region[%s]", KeyUtils.formatBytesUTF8(key), region));
            }
            if (region == null) {
                logger.debug("Key not found in keyToRegionIdCache:" + KeyUtils.formatBytesUTF8(key));
                region = this.pdClient.getRegionByKey(backOffer, key);
                if (!this.putRegion(region)) {
                    throw new TiClientInternalException("Invalid Region: " + region.toString());
                }
            }
            return region;
        }

        private synchronized boolean putRegion(TiRegion region) {
            if (logger.isDebugEnabled()) {
                logger.debug("putRegion: " + region);
            }
            this.regionCache.remove(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()));
            this.regionCache.put(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()), region);
            return true;
        }

        public synchronized boolean updateRegion(TiRegion expected, TiRegion region) {
            try {
                TiRegion oldRegion;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("invalidateRegion ID[%s]", region.getId()));
                }
                if ((oldRegion = this.regionCache.get(KeyUtils.getEncodedKey(region.getStartKey()))) == null || !expected.getMeta().equals(oldRegion.getMeta())) {
                    return false;
                }
                this.regionCache.remove(KeyRangeUtils.makeRange(oldRegion.getStartKey(), oldRegion.getEndKey()));
                this.regionCache.put(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()), region);
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }

        private synchronized TiRegion getRegionFromCache(Key key) {
            return this.regionCache.get(key);
        }

        private synchronized void invalidateRange(ByteString startKey, ByteString endKey) {
            this.regionCache.remove(KeyRangeUtils.makeRange(startKey, endKey));
        }

        public synchronized void invalidateRegion(TiRegion region) {
            try {
                TiRegion oldRegion;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("invalidateRegion ID[%s]", region.getId()));
                }
                if ((oldRegion = this.regionCache.get(KeyUtils.getEncodedKey(region.getStartKey()))) != null && oldRegion.equals(region)) {
                    this.regionCache.remove(KeyRangeUtils.makeRange(region.getStartKey(), region.getEndKey()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void invalidateAllRegionForStore(long storeId) {
            ArrayList<TiRegion> regionToRemove = new ArrayList<TiRegion>();
            for (TiRegion r : this.regionCache.asMapOfRanges().values()) {
                if (r.getLeader().getStoreId() != storeId) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("invalidateAllRegionForStore Region[%s]", r));
                }
                regionToRemove.add(r);
            }
            for (TiRegion r : regionToRemove) {
                this.regionCache.remove(KeyRangeUtils.makeRange(r.getStartKey(), r.getEndKey()));
            }
        }

        public synchronized void invalidateStore(long storeId) {
            this.storeCache.remove(storeId);
        }

        public synchronized Metapb.Store getStoreById(long id, BackOffer backOffer) {
            try {
                Metapb.Store store = this.storeCache.get(id);
                if (store == null) {
                    store = this.pdClient.getStore(backOffer, id);
                }
                if (store.getState().equals(Metapb.StoreState.Tombstone)) {
                    return null;
                }
                this.storeCache.put(id, store);
                return store;
            }
            catch (Exception e) {
                throw new GrpcException(e);
            }
        }
    }
}

