/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.statistics;

import com.sangupta.murmur.Murmur3;
import java.util.Arrays;

public class CMSketch {
    private int depth;
    private int width;
    private long count;
    private long[][] table;

    private CMSketch() {
    }

    public static CMSketch newCMSketch(int d, int w) {
        CMSketch sketch = new CMSketch();
        sketch.setTable(new long[d][w]);
        sketch.setDepth(d);
        sketch.setWidth(w);
        return sketch;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long[][] getTable() {
        return this.table;
    }

    public void setTable(long[][] table) {
        this.table = table;
    }

    public long queryBytes(byte[] bytes) {
        long[] randNums = Murmur3.hash_x64_128(bytes, bytes.length, 0L);
        long h1 = randNums[0];
        long h2 = randNums[1];
        long min = Long.MAX_VALUE;
        long[] vals = new long[this.depth];
        for (int i = 0; i < this.table.length; ++i) {
            long noise;
            int j = (int)((h1 + h2 * (long)i) % (long)this.width);
            if (min > this.table[i][j]) {
                min = this.table[i][j];
            }
            vals[i] = this.table[i][j] < (noise = (this.count - this.table[i][j]) / (long)(this.width - 1)) ? 0L : this.table[i][j] - noise;
        }
        Arrays.sort(vals);
        long res = vals[(this.depth - 1) / 2] + (vals[this.depth / 2] - vals[(this.depth - 1) / 2]) / 2L;
        if (res > min) {
            return min;
        }
        return res;
    }
}

