/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.statistics;

import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.statistics.Bucket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Histogram {
    private final long id;
    private final long numberOfDistinctValue;
    private final long nullCount;
    private final long lastUpdateVersion;
    private List<Bucket> buckets;

    private Histogram(long id, long numberOfDistinctValue, List<Bucket> buckets, long nullCount, long lastUpdateVersion) {
        this.id = id;
        this.numberOfDistinctValue = numberOfDistinctValue;
        this.buckets = buckets;
        this.nullCount = nullCount;
        this.lastUpdateVersion = lastUpdateVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getNumberOfDistinctValue() {
        return this.numberOfDistinctValue;
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    public long getNullCount() {
        return this.nullCount;
    }

    public long getLastUpdateVersion() {
        return this.lastUpdateVersion;
    }

    public long getId() {
        return this.id;
    }

    private double equalRowCount(Key values) {
        int cmp;
        int index = this.lowerBound(values);
        if (index == -this.buckets.size() - 1) {
            return 0.0;
        }
        if (index >= 0) {
            return this.buckets.get(index).getRepeats();
        }
        if (this.buckets.get(index = -index - 1).getLowerBound() == null) {
            cmp = 1;
        } else {
            Objects.requireNonNull(this.buckets.get(index).getLowerBound());
            cmp = values.compareTo(this.buckets.get(index).getLowerBound());
        }
        if (cmp < 0) {
            return 0.0;
        }
        return this.totalRowCount() / (double)this.numberOfDistinctValue;
    }

    private double greaterRowCount(Key values) {
        double lessCount = this.lessRowCount(values);
        double equalCount = this.equalRowCount(values);
        double greaterCount = this.totalRowCount() - lessCount - equalCount;
        if (greaterCount < 0.0) {
            greaterCount = 0.0;
        }
        return greaterCount;
    }

    private double greaterAndEqRowCount(Key values) {
        double greaterCount = this.greaterRowCount(values);
        double equalCount = this.equalRowCount(values);
        return greaterCount + equalCount;
    }

    private double lessRowCount(Key values) {
        if (values.compareTo(Key.NULL) <= 0) {
            return 0.0;
        }
        int index = this.lowerBound(values);
        if (index == -this.buckets.size() - 1) {
            return this.totalRowCount();
        }
        if (index >= 0) {
            return this.buckets.get((int)index).count - this.buckets.get(index).getRepeats();
        }
        index = -index - 1;
        double curCount = this.buckets.get((int)index).count;
        double preCount = 0.0;
        if (index > 0) {
            preCount = this.buckets.get((int)(index - 1)).count;
        }
        double lessThanBucketValueCount = curCount + (double)this.nullCount - (double)this.buckets.get(index).getRepeats();
        Key lowerBound = this.buckets.get(index).getLowerBound();
        int c = lowerBound != null ? values.compareTo(lowerBound) : 1;
        if (c < 0) {
            return preCount;
        }
        return (preCount + lessThanBucketValueCount) / 2.0;
    }

    public double lessAndEqRowCount(Key values) {
        double lessCount = this.lessRowCount(values);
        double equalCount = this.equalRowCount(values);
        return lessCount + equalCount;
    }

    double betweenRowCount(Key a, Key b) {
        double lessCountB;
        double lessCountA = this.lessRowCount(a);
        if (lessCountA >= (lessCountB = this.lessRowCount(b))) {
            return Math.min(lessCountB, this.totalRowCount() / (double)this.numberOfDistinctValue);
        }
        return lessCountB - lessCountA;
    }

    public double totalRowCount() {
        if (this.buckets.isEmpty()) {
            return 0.0;
        }
        return this.buckets.get((int)(this.buckets.size() - 1)).count + this.nullCount;
    }

    private int lowerBound(Key key) {
        if (this.buckets.isEmpty()) {
            return -1;
        }
        assert (key.getClass() == this.buckets.get(0).getUpperBound().getClass());
        return Arrays.binarySearch(this.buckets.toArray(), new Bucket(key));
    }

    public void mergeBlock(int bucketIdx) {
        int curBuck = 0;
        int i = 0;
        while (i + 1 <= bucketIdx) {
            this.buckets.set(curBuck++, new Bucket(this.buckets.get((int)(i + 1)).count, this.buckets.get(i + 1).getRepeats(), this.buckets.get(i + 1).getLowerBound(), this.buckets.get(i).getUpperBound()));
            i += 2;
        }
        if (bucketIdx % 2 == 0) {
            this.buckets.set(curBuck++, this.buckets.get(bucketIdx));
        }
        this.buckets = this.buckets.subList(0, curBuck);
    }

    double getIncreaseFactor(long totalCount) {
        long columnCount = this.buckets.get((int)(this.buckets.size() - 1)).count + this.nullCount;
        if (columnCount == 0L) {
            return 1.0;
        }
        return (double)totalCount / (double)columnCount;
    }

    public String toString() {
        return "Histogram {\n id:" + this.id + ",\n ndv:" + this.numberOfDistinctValue + ",\n nullCount:" + this.nullCount + ", buckets:[" + this.buckets + "]\n}";
    }

    public static class Builder {
        private long id;
        private long NDV;
        private List<Bucket> buckets = new ArrayList<Bucket>();
        private long nullCount;
        private long lastUpdateVersion;

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setNDV(long NDV) {
            this.NDV = NDV;
            return this;
        }

        public Builder setBuckets(List<Bucket> buckets) {
            this.buckets = new ArrayList<Bucket>(buckets);
            return this;
        }

        public Builder setNullCount(long nullCount) {
            this.nullCount = nullCount;
            return this;
        }

        public Builder setLastUpdateVersion(long lastUpdateVersion) {
            this.lastUpdateVersion = lastUpdateVersion;
            return this;
        }

        public Histogram build() {
            return new Histogram(this.id, this.NDV, this.buckets, this.nullCount, this.lastUpdateVersion);
        }
    }
}

