/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.statistics;

import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.StatisticsKeyRangeBuilder;
import com.pingcap.tikv.meta.TiIndexInfo;
import com.pingcap.tikv.predicates.IndexRange;
import com.pingcap.tikv.statistics.CMSketch;
import com.pingcap.tikv.statistics.Histogram;
import com.pingcap.tikv.util.Pair;
import java.util.List;

public class IndexStatistics {
    private Histogram histogram;
    private CMSketch cmSketch;
    private TiIndexInfo indexInfo;

    public IndexStatistics(Histogram histogram, CMSketch cmSketch, TiIndexInfo indexInfo) {
        this.histogram = histogram;
        this.cmSketch = cmSketch;
        this.indexInfo = indexInfo;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
    }

    public CMSketch getCmSketch() {
        return this.cmSketch;
    }

    public void setCmSketch(CMSketch cmSketch) {
        this.cmSketch = cmSketch;
    }

    public TiIndexInfo getIndexInfo() {
        return this.indexInfo;
    }

    public void setIndexInfo(TiIndexInfo indexInfo) {
        this.indexInfo = indexInfo;
    }

    public double getRowCount(List<IndexRange> indexRanges) {
        double rowCount = 0.0;
        for (IndexRange ir : indexRanges) {
            StatisticsKeyRangeBuilder builder = new StatisticsKeyRangeBuilder(ir);
            Pair<Key, Key> range = builder.compute();
            rowCount += this.histogram.betweenRowCount((Key)range.first, (Key)range.second);
        }
        if (rowCount > this.histogram.totalRowCount()) {
            rowCount = this.histogram.totalRowCount();
        } else if (rowCount < 0.0) {
            rowCount = 0.0;
        }
        return rowCount;
    }
}

