/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.txn;

import com.pingcap.tikv.exception.ResolveLockException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class AsyncResolveData {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncResolveData.class);
    private long commitTs;
    private List<ByteString> keys;
    private boolean missingLock;

    public AsyncResolveData(long commitTs, List<ByteString> keys, boolean missingLock) {
        this.commitTs = commitTs;
        this.keys = keys;
        this.missingLock = missingLock;
    }

    public long getCommitTs() {
        return this.commitTs;
    }

    public List<ByteString> getKeys() {
        return this.keys;
    }

    public synchronized void appendKey(ByteString key) {
        ArrayList<ByteString> newKeys = new ArrayList<ByteString>(this.getKeys());
        newKeys.add(key);
        this.keys = newKeys;
    }

    public synchronized void addKeys(List<Kvrpcpb.LockInfo> locks, int expected, long startTs, long commitTs) throws ResolveLockException {
        if (locks.size() < expected) {
            LOG.debug(String.format("addKeys: lock has been committed or rolled back, startTs=%d, commitTs=%d", startTs, commitTs));
            if (!this.missingLock) {
                if (commitTs != 0L && commitTs < this.commitTs) {
                    throw new ResolveLockException(String.format("commit TS must be greater or equal to min commit TS, commitTs=%d, minCommitTs=%d", commitTs, this.commitTs));
                }
                this.commitTs = commitTs;
            }
            this.missingLock = true;
            if (this.commitTs != commitTs) {
                throw new ResolveLockException(String.format("commit TS mismatch in async commit recovery: %d and %d", this.commitTs, commitTs));
            }
        } else {
            LOG.debug(String.format("addKeys: all locks present, startTs=%d", startTs));
            for (Kvrpcpb.LockInfo lockInfo : locks) {
                if (lockInfo.getLockVersion() != startTs) {
                    throw new ResolveLockException(String.format("unexpected timestamp, expected: %d, found: %d", startTs, lockInfo.getLockVersion()));
                }
                if (!this.missingLock && lockInfo.getMinCommitTs() > this.commitTs) {
                    this.commitTs = lockInfo.getMinCommitTs();
                }
                this.appendKey(lockInfo.getKey());
            }
        }
    }
}

