/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tidb.tipb.ExprType;
import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.exception.ConvertNotSupportException;
import com.pingcap.tikv.exception.ConvertOverflowException;
import com.pingcap.tikv.exception.TypeException;
import com.pingcap.tikv.exception.UnsupportedTypeException;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tikv.types.MySQLType;

public class SetType
extends DataType {
    public static final SetType SET = new SetType(MySQLType.TypeSet);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeSet};

    private SetType(MySQLType tp) {
        super(tp);
    }

    protected SetType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        long number;
        switch (flag) {
            case 9: {
                number = Codec.IntegerCodec.readUVarLong(cdi);
                break;
            }
            case 4: {
                number = Codec.IntegerCodec.readULong(cdi);
                break;
            }
            default: {
                throw new TypeException("Invalid IntegerType flag: " + flag);
            }
        }
        return Codec.SetCodec.readSetFromLong(number, this.getElems());
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Set type cannot be pushed down.");
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Set type cannot be pushed down.");
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        throw new UnsupportedTypeException("Set type cannot be pushed down.");
    }

    @Override
    public String getName() {
        return "SET";
    }

    @Override
    public ExprType getProtoExprType() {
        return ExprType.MysqlSet;
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return value;
    }

    @Override
    public boolean isPushDownSupported() {
        return false;
    }
}

