/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.Batch;
import com.pingcap.tikv.util.FastByteComparisons;
import com.pingcap.tikv.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class ClientUtils {
    public static void appendBatches(BackOffer backOffer, List<Batch> batches, TiRegion region, List<ByteString> keys, int batchMaxSizeInBytes, int batchLimit) {
        if (keys == null) {
            return;
        }
        int len = keys.size();
        int start = 0;
        while (start < len) {
            int end;
            int size = 0;
            for (end = start; end < len && size < batchMaxSizeInBytes && end - start < batchLimit; size += keys.get(end).size(), ++end) {
            }
            Batch batch = new Batch(backOffer, region, keys.subList(start, end));
            batches.add(batch);
            start = end;
        }
    }

    public static void appendBatches(BackOffer backOffer, List<Batch> batches, TiRegion region, List<ByteString> keys, List<ByteString> values, int batchMaxSizeInBytes, int batchLimit) {
        if (keys == null) {
            return;
        }
        int len = keys.size();
        int start = 0;
        while (start < len) {
            int end;
            int size = 0;
            for (end = start; end < len && size < batchMaxSizeInBytes && end - start < batchLimit; size += values.get(end).size(), ++end) {
                size += keys.get(end).size();
            }
            Batch batch = new Batch(backOffer, region, keys.subList(start, end), values.subList(start, end));
            batches.add(batch);
            start = end;
        }
    }

    public static List<Batch> getBatches(BackOffer backOffer, List<ByteString> keys, int batchSize, int batchLimit, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        Map<TiRegion, List<ByteString>> groupKeys = ClientUtils.groupKeysByRegion(clientBuilder.getRegionManager(), keys, backOffer);
        ArrayList<Batch> retryBatches = new ArrayList<Batch>();
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            ClientUtils.appendBatches(backOffer, retryBatches, entry.getKey(), entry.getValue(), batchSize, batchLimit);
        }
        return retryBatches;
    }

    public static Map<TiRegion, List<ByteString>> groupKeysByRegion(RegionManager regionManager, Set<ByteString> keys, BackOffer backoffer) {
        return ClientUtils.groupKeysByRegion(regionManager, new ArrayList<ByteString>(keys), backoffer, true);
    }

    public static Map<TiRegion, List<ByteString>> groupKeysByRegion(RegionManager regionManager, List<ByteString> keys, BackOffer backoffer) {
        return ClientUtils.groupKeysByRegion(regionManager, keys, backoffer, false);
    }

    public static Map<TiRegion, List<ByteString>> groupKeysByRegion(RegionManager regionManager, List<ByteString> keys, BackOffer backoffer, boolean sorted) {
        HashMap<TiRegion, List<ByteString>> groups = new HashMap<TiRegion, List<ByteString>>();
        Stream keyStream = keys.stream();
        if (!sorted) {
            keyStream = keys.stream().sorted((k1, k2) -> FastByteComparisons.compareTo(k1.toByteArray(), k2.toByteArray()));
        }
        TiRegion lastRegion = null;
        for (ByteString key : (ByteString[])keyStream.toArray(ByteString[]::new)) {
            if (lastRegion == null || !lastRegion.contains(key)) {
                lastRegion = regionManager.getRegionByKey(key, backoffer);
            }
            groups.computeIfAbsent(lastRegion, k -> new ArrayList()).add(key);
        }
        return groups;
    }

    public static List<Kvrpcpb.KvPair> getKvPairs(ExecutorCompletionService<List<Kvrpcpb.KvPair>> completionService, List<Batch> batches, int backOff) {
        try {
            ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
            for (int i = 0; i < batches.size(); ++i) {
                result.addAll((Collection<Kvrpcpb.KvPair>)completionService.take().get(backOff, TimeUnit.MILLISECONDS));
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TiKVException("Current thread interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new TiKVException("TimeOut Exceeded for current operation. ", e);
        }
        catch (ExecutionException e) {
            throw new TiKVException("Execution exception met.", e);
        }
    }

    public static <T> void getTasks(ExecutorCompletionService<List<T>> completionService, Queue<List<T>> taskQueue, List<T> batches, int backOff) {
        try {
            for (int i = 0; i < batches.size(); ++i) {
                List<T> task = completionService.take().get(backOff, TimeUnit.MILLISECONDS);
                if (task.isEmpty()) continue;
                taskQueue.offer(task);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TiKVException("Current thread interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new TiKVException("TimeOut Exceeded for current operation. ", e);
        }
        catch (ExecutionException e) {
            throw new TiKVException("Execution exception met.", e);
        }
    }

    public static <T, U> List<U> getTasksWithOutput(ExecutorCompletionService<Pair<List<T>, List<U>>> completionService, Queue<List<T>> taskQueue, List<T> batches, int backOff) {
        try {
            ArrayList result = new ArrayList();
            for (int i = 0; i < batches.size(); ++i) {
                Pair<List<T>, List<U>> task = completionService.take().get(backOff, TimeUnit.MILLISECONDS);
                if (!((List)task.first).isEmpty()) {
                    taskQueue.offer((List<T>)task.first);
                    continue;
                }
                result.addAll((Collection)task.second);
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TiKVException("Current thread interrupted.", e);
        }
        catch (TimeoutException e) {
            throw new TiKVException("TimeOut Exceeded for current operation. ", e);
        }
        catch (ExecutionException e) {
            throw new TiKVException("Execution exception met.", e);
        }
    }
}

