/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.util;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.key.Handle;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.key.RowKey;
import com.pingcap.tikv.pd.PDUtils;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.FastByteComparisons;
import com.pingcap.tikv.util.KeyRangeUtils;
import com.pingcap.tikv.util.Pair;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Coprocessor;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class RangeSplitter {
    private final RegionManager regionManager;
    private static final Logger LOG = LoggerFactory.getLogger(RangeSplitter.class);

    private RangeSplitter(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public static RangeSplitter newSplitter(RegionManager mgr) {
        return new RangeSplitter(mgr);
    }

    public Map<Pair<TiRegion, Metapb.Store>, List<Handle>> groupByAndSortHandlesByRegionId(long tableId, List<Handle> handles) {
        TLongObjectHashMap<List> regionHandles = new TLongObjectHashMap<List>();
        TLongObjectHashMap<Pair<TiRegion, Metapb.Store>> idToRegionStorePair = new TLongObjectHashMap<Pair<TiRegion, Metapb.Store>>();
        HashMap<Pair<TiRegion, Metapb.Store>, List<Handle>> result = new HashMap<Pair<TiRegion, Metapb.Store>, List<Handle>>();
        handles.sort(Handle::compare);
        byte[] endKey = null;
        TiRegion curRegion = null;
        ArrayList<Handle> handlesInCurRegion = new ArrayList<Handle>();
        for (Handle curHandle : handles) {
            RowKey key = RowKey.toRowKey(tableId, curHandle);
            if (endKey == null || endKey.length != 0 && FastByteComparisons.compareTo(key.getBytes(), endKey) >= 0) {
                if (curRegion != null) {
                    regionHandles.put(curRegion.getId(), handlesInCurRegion);
                    handlesInCurRegion = new ArrayList();
                }
                Pair<TiRegion, Metapb.Store> regionStorePair = this.regionManager.getRegionStorePairByKey(ByteString.copyFrom(key.getBytes()));
                curRegion = (TiRegion)regionStorePair.first;
                idToRegionStorePair.put(curRegion.getId(), regionStorePair);
                endKey = curRegion.getEndKey().toByteArray();
            }
            handlesInCurRegion.add(curHandle);
        }
        if (!handlesInCurRegion.isEmpty()) {
            regionHandles.put(curRegion.getId(), handlesInCurRegion);
        }
        regionHandles.forEachEntry((k, v) -> {
            Pair regionStorePair = (Pair)idToRegionStorePair.get(k);
            result.put(regionStorePair, (List<Handle>)v);
            return true;
        });
        return result;
    }

    public List<RegionTask> splitAndSortHandlesByRegion(List<Long> ids, List<Handle> handles) {
        HashSet<RegionTask> regionTasks = new HashSet<RegionTask>();
        for (Long id : ids) {
            regionTasks.addAll(this.splitAndSortHandlesByRegion(id, handles));
        }
        return new ArrayList<RegionTask>(regionTasks);
    }

    private List<RegionTask> splitAndSortHandlesByRegion(long tableId, List<Handle> handles) {
        ImmutableList.Builder regionTasks = ImmutableList.builder();
        Map<Pair<TiRegion, Metapb.Store>, List<Handle>> regionHandlesMap = this.groupByAndSortHandlesByRegionId(tableId, handles);
        regionHandlesMap.forEach((k, v) -> this.createTask(0, v.size(), tableId, (List<Handle>)v, (Pair<TiRegion, Metapb.Store>)k, regionTasks));
        return regionTasks.build();
    }

    private void createTask(int startPos, int endPos, long tableId, List<Handle> handles, Pair<TiRegion, Metapb.Store> regionStorePair, ImmutableList.Builder<RegionTask> regionTasks) {
        Handle startHandle;
        ArrayList<Coprocessor.KeyRange> newKeyRanges = new ArrayList<Coprocessor.KeyRange>(endPos - startPos + 1);
        Handle endHandle = startHandle = handles.get(startPos);
        for (int i = startPos + 1; i < endPos; ++i) {
            Handle curHandle = handles.get(i);
            if (endHandle.next().equals(curHandle)) {
                endHandle = curHandle;
                continue;
            }
            newKeyRanges.add(KeyRangeUtils.makeCoprocRange(RowKey.toRowKey(tableId, startHandle).toByteString(), RowKey.toRowKey(tableId, endHandle.next()).toByteString()));
            endHandle = startHandle = curHandle;
        }
        newKeyRanges.add(KeyRangeUtils.makeCoprocRange(RowKey.toRowKey(tableId, startHandle).toByteString(), RowKey.toRowKey(tableId, endHandle.next()).toByteString()));
        regionTasks.add((Object)new RegionTask((TiRegion)regionStorePair.first, (Metapb.Store)regionStorePair.second, newKeyRanges));
    }

    public List<RegionTask> splitRangeByRegion(List<Coprocessor.KeyRange> keyRanges, TiStoreType storeType) {
        if (keyRanges == null || keyRanges.size() == 0) {
            return ImmutableList.of();
        }
        int i = 0;
        Coprocessor.KeyRange range = keyRanges.get(i++);
        HashMap<Long, List> idToRange = new HashMap<Long, List>();
        HashMap<Long, Pair<TiRegion, Metapb.Store>> idToRegion = new HashMap<Long, Pair<TiRegion, Metapb.Store>>();
        while (true) {
            Pair<TiRegion, Metapb.Store> regionStorePair = null;
            ConcreteBackOffer bo = ConcreteBackOffer.newGetBackOff();
            while (regionStorePair == null) {
                try {
                    regionStorePair = this.regionManager.getRegionStorePairByKey(range.getStart(), storeType, bo);
                    if (regionStorePair != null) continue;
                    throw new NullPointerException("fail to get region/store pair by key " + KeyRangeUtils.formatByteString(range.getStart()));
                }
                catch (Exception e) {
                    LOG.warn("getRegionStorePairByKey error", (Throwable)e);
                    bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                }
            }
            TiRegion region = (TiRegion)regionStorePair.first;
            idToRegion.putIfAbsent(region.getId(), regionStorePair);
            if (Key.toRawKey(range.getEnd()).compareTo(Key.toRawKey(region.getEndKey())) > 0) {
                Coprocessor.KeyRange cutRange = Coprocessor.KeyRange.newBuilder().setStart(range.getStart()).setEnd(region.getEndKey()).build();
                List ranges = idToRange.computeIfAbsent(region.getId(), k -> new ArrayList());
                ranges.add(cutRange);
                range = Coprocessor.KeyRange.newBuilder().setStart(region.getEndKey()).setEnd(range.getEnd()).build();
                continue;
            }
            List ranges = idToRange.computeIfAbsent(region.getId(), k -> new ArrayList());
            ranges.add(range);
            if (i >= keyRanges.size()) break;
            range = keyRanges.get(i++);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        idToRange.forEach((k, v) -> {
            Pair regionStorePair = (Pair)idToRegion.get(k);
            resultBuilder.add(new RegionTask((TiRegion)regionStorePair.first, (Metapb.Store)regionStorePair.second, (List<Coprocessor.KeyRange>)v));
        });
        return resultBuilder.build();
    }

    public List<RegionTask> splitRangeByRegion(List<Coprocessor.KeyRange> keyRanges) {
        return this.splitRangeByRegion(keyRanges, TiStoreType.TiKV);
    }

    public static class RegionTask
    implements Serializable {
        private final TiRegion region;
        private final Metapb.Store store;
        private final List<Coprocessor.KeyRange> ranges;
        private final String host;

        RegionTask(TiRegion region, Metapb.Store store, List<Coprocessor.KeyRange> ranges) {
            this.region = region;
            this.store = store;
            this.ranges = ranges;
            String host = null;
            try {
                host = PDUtils.addrToUrl(store.getAddress()).getHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = host;
        }

        public static RegionTask newInstance(TiRegion region, Metapb.Store store, List<Coprocessor.KeyRange> ranges) {
            return new RegionTask(region, store, ranges);
        }

        public TiRegion getRegion() {
            return this.region;
        }

        public Metapb.Store getStore() {
            return this.store;
        }

        public List<Coprocessor.KeyRange> getRanges() {
            return this.ranges;
        }

        public String getHost() {
            return this.host;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Region [%s]", this.region));
            sb.append(" ");
            for (Coprocessor.KeyRange range : this.ranges) {
                sb.append(String.format("Range Start: [%s] Range End: [%s]", KeyRangeUtils.formatByteString(range.getStart()), KeyRangeUtils.formatByteString(range.getEnd())));
            }
            return sb.toString();
        }
    }
}

