/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.watch;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import io.etcd.jetcd.AbstractResponse;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.api.Event;
import io.etcd.jetcd.watch.WatchEvent;
import java.util.List;
import java.util.stream.Collectors;

public class WatchResponse
extends AbstractResponse<io.etcd.jetcd.api.WatchResponse> {
    private List<WatchEvent> events;
    private final ByteSequence namespace;

    public WatchResponse(io.etcd.jetcd.api.WatchResponse response, ByteSequence namespace) {
        super(response, response.getHeader());
        this.namespace = namespace;
    }

    @VisibleForTesting
    public WatchResponse(io.etcd.jetcd.api.WatchResponse response) {
        this(response, ByteSequence.EMPTY);
    }

    private static WatchEvent toEvent(Event event, ByteSequence namespace) {
        WatchEvent.EventType eventType;
        switch (event.getType()) {
            case DELETE: {
                eventType = WatchEvent.EventType.DELETE;
                break;
            }
            case PUT: {
                eventType = WatchEvent.EventType.PUT;
                break;
            }
            default: {
                eventType = WatchEvent.EventType.UNRECOGNIZED;
            }
        }
        return new WatchEvent(new KeyValue(event.getKv(), namespace), new KeyValue(event.getPrevKv(), namespace), eventType);
    }

    public synchronized List<WatchEvent> getEvents() {
        if (this.events == null) {
            this.events = ((io.etcd.jetcd.api.WatchResponse)this.getResponse()).getEventsList().stream().map(event -> WatchResponse.toEvent(event, this.namespace)).collect(Collectors.toList());
        }
        return this.events;
    }
}

