/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc;

import java.util.Collections;
import shade.io.grpc.Internal;
import shade.io.grpc.ManagedChannelProvider;
import shade.io.grpc.ServerBuilder;
import shade.io.grpc.ServiceProviders;

@Internal
public abstract class ServerProvider {
    private static final ServerProvider provider = ServiceProviders.load(ServerProvider.class, Collections.emptyList(), ServerProvider.class.getClassLoader(), new ServiceProviders.PriorityAccessor<ServerProvider>(){

        @Override
        public boolean isAvailable(ServerProvider provider) {
            return provider.isAvailable();
        }

        @Override
        public int getPriority(ServerProvider provider) {
            return provider.priority();
        }
    });

    public static ServerProvider provider() {
        if (provider == null) {
            throw new ManagedChannelProvider.ProviderNotFoundException("No functional server found. Try adding a dependency on the grpc-netty or grpc-netty-shaded artifact");
        }
        return provider;
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    protected abstract ServerBuilder<?> builderForPort(int var1);
}

